#!/bin/bash


function getValHigh() {
    sed -n '/'"${1}"'/,/<\/Sample>/p' $2 | grep "$3" | grep "OverallSys" | awk '{print $3}' | sed 's/"/ /g' | awk '{print $2}'
}

function getValLow() {
    sed -n '/'"${1}"'/,/<\/Sample>/p' $2 | grep "$3" | grep "OverallSys" | awk '{print $4}' | sed 's/"/ /g' | awk '{print $2}'
}

function getSum() {
    let    sum=0
    for i in ${@}; do
	sum=`echo "scale=6; if (${i}-1>0) $sum + (${i}-1)*(${i}-1) else $sum - (${i}-1)*(${i}-1)" | bc`
    done
    echo "scale=6; if ($sum > 0) 1+sqrt($sum) else 1-sqrt(-($sum))" | bc
}


function getFlavSyst() {
    b_eff1=`getValHigh "<Sample Name=\"${2}\"" $1 "B_EFF"`
    c_eff1=`getValHigh "<Sample Name=\"${2}\"" $1 "C_EFF"`
    l_eff1=`getValHigh "<Sample Name=\"${2}\"" $1 "L_EFF"`

    b_eff2=`getValLow "<Sample Name=\"${2}\"" $1 "B_EFF"`
    c_eff2=`getValLow "<Sample Name=\"${2}\"" $1 "C_EFF"`
    l_eff2=`getValLow "<Sample Name=\"${2}\"" $1 "L_EFF"`

    high=`getSum $b_eff1 $c_eff1 $l_eff1`
    low=`getSum $b_eff2 $c_eff2 $l_eff2`

    printf "<OverallSys Name=\"%s\" High=\"%4.3f\" Low=\"%4.3f\" /> <!-- %s %s --> \n" "$3" $high $low "$2" "$4"
}

function getJESSyst() {

    b_eff1=`getValHigh "<Sample Name=\"${2}\"" $1 "JES"`
    c_eff1=`getValHigh "<Sample Name=\"${2}\"" $1 "METPileUp"`
    l_eff1=`getValHigh "<Sample Name=\"${2}\"" $1 "Cluster"`

    b_eff2=`getValLow "<Sample Name=\"${2}\"" $1 "JES"`
    c_eff2=`getValLow "<Sample Name=\"${2}\"" $1 "METPileUp"`
    l_eff2=`getValLow "<Sample Name=\"${2}\"" $1 "Cluster"`

    high=`getSum $b_eff1 $c_eff1 $l_eff1`
    low=`getSum $b_eff2 $c_eff2 $l_eff2`

    printf "<OverallSys Name=\"%s\" High=\"%4.3f\" Low=\"%4.3f\" /> <!-- %s %s --> \n" "$3" $high $low "$2" "$4"


}

# BTAG Channels
######################################################################################
FILE_BTAGEle="b_mA130tb10_BTAG_el.xml"

getFlavSyst $FILE_BTAGEle "ATLAS_Bkg_singletop"     "B_EFF" "BTAG_el"
getFlavSyst $FILE_BTAGEle "ATLAS_Bkg_top"           "B_EFF" "BTAG_el"
getFlavSyst $FILE_BTAGEle "ATLAS_Bkg_QCDLH"         "B_EFF" "BTAG_el"
getFlavSyst $FILE_BTAGEle "ATLAS_Bkg_Zjets"         "B_EFF" "BTAG_el"
getFlavSyst $FILE_BTAGEle "ATLAS_Bkg_W"             "B_EFF" "BTAG_el"

getFlavSyst b_mA090tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh090"  "B_EFF" "BTAG_el"
getFlavSyst b_mA100tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh100"  "B_EFF" "BTAG_el"
getFlavSyst b_mA110tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh110"  "B_EFF" "BTAG_el"
getFlavSyst b_mA120tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh120"  "B_EFF" "BTAG_el"
getFlavSyst b_mA130tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh130"  "B_EFF" "BTAG_el"
getFlavSyst b_mA140tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh140"  "B_EFF" "BTAG_el"
getFlavSyst b_mA150tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh150"  "B_EFF" "BTAG_el"
getFlavSyst b_mA170tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh170"  "B_EFF" "BTAG_el"
getFlavSyst b_mA200tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh200"  "B_EFF" "BTAG_el"
getFlavSyst b_mA250tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh250"  "B_EFF" "BTAG_el"
getFlavSyst b_mA300tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh300"  "B_EFF" "BTAG_el"
getFlavSyst b_mA350tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh350"  "B_EFF" "BTAG_el"
getFlavSyst b_mA400tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh400"  "B_EFF" "BTAG_el"
getFlavSyst b_mA450tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh450"  "B_EFF" "BTAG_el"
getFlavSyst b_mA500tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh500"  "B_EFF" "BTAG_el"

getFlavSyst b_mA090tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh090"  "B_EFF" "BTAG_el"
getFlavSyst b_mA100tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh100"  "B_EFF" "BTAG_el"
getFlavSyst b_mA110tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh110"  "B_EFF" "BTAG_el"
getFlavSyst b_mA120tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh120"  "B_EFF" "BTAG_el"
getFlavSyst b_mA130tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh130"  "B_EFF" "BTAG_el"
getFlavSyst b_mA140tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh140"  "B_EFF" "BTAG_el"
getFlavSyst b_mA150tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh150"  "B_EFF" "BTAG_el"
getFlavSyst b_mA170tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh170"  "B_EFF" "BTAG_el"
getFlavSyst b_mA200tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh200"  "B_EFF" "BTAG_el"
getFlavSyst b_mA250tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh250"  "B_EFF" "BTAG_el"
getFlavSyst b_mA300tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh300"  "B_EFF" "BTAG_el"
getFlavSyst b_mA350tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh350"  "B_EFF" "BTAG_el"
getFlavSyst b_mA400tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh400"  "B_EFF" "BTAG_el"
getFlavSyst b_mA450tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh450"  "B_EFF" "BTAG_el"
getFlavSyst b_mA500tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh500"  "B_EFF" "BTAG_el"


getJESSyst $FILE_BTAGEle "ATLAS_Bkg_singletop"     "JES" "BTAG_el"
getJESSyst $FILE_BTAGEle "ATLAS_Bkg_top"           "JES" "BTAG_el"
getJESSyst $FILE_BTAGEle "ATLAS_Bkg_QCDLH"         "JES" "BTAG_el"
getJESSyst $FILE_BTAGEle "ATLAS_Bkg_Zjets"         "JES" "BTAG_el"
getJESSyst $FILE_BTAGEle "ATLAS_Bkg_W"             "JES" "BTAG_el"
getJESSyst $FILE_BTAGEle "ATLAS_Bkg_Ztau"          "JES" "BTAG_el"

getJESSyst b_mA090tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh090"  "JES" "BTAG_el"
getJESSyst b_mA100tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh100"  "JES" "BTAG_el"
getJESSyst b_mA110tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh110"  "JES" "BTAG_el"
getJESSyst b_mA120tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh120"  "JES" "BTAG_el"
getJESSyst b_mA130tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh130"  "JES" "BTAG_el"
getJESSyst b_mA140tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh140"  "JES" "BTAG_el"
getJESSyst b_mA150tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh150"  "JES" "BTAG_el"
getJESSyst b_mA170tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh170"  "JES" "BTAG_el"
getJESSyst b_mA200tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh200"  "JES" "BTAG_el"
getJESSyst b_mA250tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh250"  "JES" "BTAG_el"
getJESSyst b_mA300tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh300"  "JES" "BTAG_el"
getJESSyst b_mA350tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh350"  "JES" "BTAG_el"
getJESSyst b_mA400tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh400"  "JES" "BTAG_el"
getJESSyst b_mA450tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh450"  "JES" "BTAG_el"
getJESSyst b_mA500tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh500"  "JES" "BTAG_el"

getJESSyst b_mA090tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh090"  "JES" "BTAG_el"
getJESSyst b_mA100tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh100"  "JES" "BTAG_el"
getJESSyst b_mA110tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh110"  "JES" "BTAG_el"
getJESSyst b_mA120tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh120"  "JES" "BTAG_el"
getJESSyst b_mA130tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh130"  "JES" "BTAG_el"
getJESSyst b_mA140tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh140"  "JES" "BTAG_el"
getJESSyst b_mA150tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh150"  "JES" "BTAG_el"
getJESSyst b_mA170tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh170"  "JES" "BTAG_el"
getJESSyst b_mA200tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh200"  "JES" "BTAG_el"
getJESSyst b_mA250tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh250"  "JES" "BTAG_el"
getJESSyst b_mA300tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh300"  "JES" "BTAG_el"
getJESSyst b_mA350tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh350"  "JES" "BTAG_el"
getJESSyst b_mA400tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh400"  "JES" "BTAG_el"
getJESSyst b_mA450tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh450"  "JES" "BTAG_el"
getJESSyst b_mA500tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh500"  "JES" "BTAG_el"




FILE_BTAGEle="b_mA130tb10_BTAG_mu.xml"

getFlavSyst $FILE_BTAGEle "ATLAS_Bkg_singletop"     "B_EFF" "BTAG_mu"
getFlavSyst $FILE_BTAGEle "ATLAS_Bkg_top"           "B_EFF" "BTAG_mu"
getFlavSyst $FILE_BTAGEle "ATLAS_Bkg_QCDLH"         "B_EFF" "BTAG_mu"
getFlavSyst $FILE_BTAGEle "ATLAS_Bkg_Zjets"         "B_EFF" "BTAG_mu"
getFlavSyst $FILE_BTAGEle "ATLAS_Bkg_W"             "B_EFF" "BTAG_mu"

getFlavSyst b_mA090tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh090"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA100tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh100"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA110tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh110"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA120tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh120"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA130tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh130"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA140tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh140"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA150tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh150"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA170tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh170"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA200tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh200"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA250tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh250"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA300tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh300"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA350tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh350"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA400tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh400"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA450tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh450"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA500tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh500"  "B_EFF" "BTAG_mu"

getFlavSyst b_mA090tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh090"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA100tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh100"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA110tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh110"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA120tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh120"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA130tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh130"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA140tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh140"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA150tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh150"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA170tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh170"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA200tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh200"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA250tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh250"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA300tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh300"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA350tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh350"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA400tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh400"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA450tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh450"  "B_EFF" "BTAG_mu"
getFlavSyst b_mA500tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh500"  "B_EFF" "BTAG_mu"

getJESSyst $FILE_BTAGEle "ATLAS_Bkg_singletop"     "JES" "BTAG_mu"
getJESSyst $FILE_BTAGEle "ATLAS_Bkg_top"           "JES" "BTAG_mu"
getJESSyst $FILE_BTAGEle "ATLAS_Bkg_QCDLH"         "JES" "BTAG_mu"
getJESSyst $FILE_BTAGEle "ATLAS_Bkg_Zjets"         "JES" "BTAG_mu"
getJESSyst $FILE_BTAGEle "ATLAS_Bkg_W"             "JES" "BTAG_mu"
getJESSyst $FILE_BTAGEle "ATLAS_Bkg_Ztau"          "JES" "BTAG_mu"

getJESSyst b_mA090tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh090"  "JES" "BTAG_mu"
getJESSyst b_mA100tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh100"  "JES" "BTAG_mu"
getJESSyst b_mA110tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh110"  "JES" "BTAG_mu"
getJESSyst b_mA120tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh120"  "JES" "BTAG_mu"
getJESSyst b_mA130tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh130"  "JES" "BTAG_mu"
getJESSyst b_mA140tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh140"  "JES" "BTAG_mu"
getJESSyst b_mA150tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh150"  "JES" "BTAG_mu"
getJESSyst b_mA170tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh170"  "JES" "BTAG_mu"
getJESSyst b_mA200tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh200"  "JES" "BTAG_mu"
getJESSyst b_mA250tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh250"  "JES" "BTAG_mu"
getJESSyst b_mA300tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh300"  "JES" "BTAG_mu"
getJESSyst b_mA350tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh350"  "JES" "BTAG_mu"
getJESSyst b_mA400tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh400"  "JES" "BTAG_mu"
getJESSyst b_mA450tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh450"  "JES" "BTAG_mu"
getJESSyst b_mA500tb10_BTAG_el.xml "ATLAS_Sig_HiggsggAlh500"  "JES" "BTAG_mu"

getJESSyst b_mA090tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh090"  "JES" "BTAG_mu"
getJESSyst b_mA100tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh100"  "JES" "BTAG_mu"
getJESSyst b_mA110tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh110"  "JES" "BTAG_mu"
getJESSyst b_mA120tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh120"  "JES" "BTAG_mu"
getJESSyst b_mA130tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh130"  "JES" "BTAG_mu"
getJESSyst b_mA140tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh140"  "JES" "BTAG_mu"
getJESSyst b_mA150tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh150"  "JES" "BTAG_mu"
getJESSyst b_mA170tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh170"  "JES" "BTAG_mu"
getJESSyst b_mA200tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh200"  "JES" "BTAG_mu"
getJESSyst b_mA250tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh250"  "JES" "BTAG_mu"
getJESSyst b_mA300tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh300"  "JES" "BTAG_mu"
getJESSyst b_mA350tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh350"  "JES" "BTAG_mu"
getJESSyst b_mA400tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh400"  "JES" "BTAG_mu"
getJESSyst b_mA450tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh450"  "JES" "BTAG_mu"
getJESSyst b_mA500tb10_BTAG_el.xml "ATLAS_Sig_HiggsbbAlh500"  "JES" "BTAG_mu"

######################################################################################


# bveto channels


FILE_BVETOEle="b_mA130tb10_BVETO_el.xml"

getFlavSyst $FILE_BVETOEle "ATLAS_Bkg_diboson"       "B_EFF" "BVETO_el"
getFlavSyst $FILE_BVETOEle "ATLAS_Bkg_singletop"     "B_EFF" "BVETO_el"
getFlavSyst $FILE_BVETOEle "ATLAS_Bkg_top"           "B_EFF" "BVETO_el"
getFlavSyst $FILE_BVETOEle "ATLAS_Bkg_QCDLH"         "B_EFF" "BVETO_el"
getFlavSyst $FILE_BVETOEle "ATLAS_Bkg_Zjets"         "B_EFF" "BVETO_el"
getFlavSyst $FILE_BVETOEle "ATLAS_Bkg_W"             "B_EFF" "BVETO_el"

getFlavSyst b_mA090tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh090"  "B_EFF" "BVETO_el"
getFlavSyst b_mA100tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh100"  "B_EFF" "BVETO_el"
getFlavSyst b_mA110tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh110"  "B_EFF" "BVETO_el"
getFlavSyst b_mA120tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh120"  "B_EFF" "BVETO_el"
getFlavSyst b_mA130tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh130"  "B_EFF" "BVETO_el"
getFlavSyst b_mA140tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh140"  "B_EFF" "BVETO_el"
getFlavSyst b_mA150tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh150"  "B_EFF" "BVETO_el"
getFlavSyst b_mA170tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh170"  "B_EFF" "BVETO_el"
getFlavSyst b_mA200tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh200"  "B_EFF" "BVETO_el"
getFlavSyst b_mA250tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh250"  "B_EFF" "BVETO_el"
getFlavSyst b_mA300tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh300"  "B_EFF" "BVETO_el"
getFlavSyst b_mA350tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh350"  "B_EFF" "BVETO_el"
getFlavSyst b_mA400tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh400"  "B_EFF" "BVETO_el"
getFlavSyst b_mA450tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh450"  "B_EFF" "BVETO_el"
getFlavSyst b_mA500tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh500"  "B_EFF" "BVETO_el"

getFlavSyst b_mA090tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh090"  "B_EFF" "BVETO_el"
getFlavSyst b_mA100tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh100"  "B_EFF" "BVETO_el"
getFlavSyst b_mA110tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh110"  "B_EFF" "BVETO_el"
getFlavSyst b_mA120tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh120"  "B_EFF" "BVETO_el"
getFlavSyst b_mA130tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh130"  "B_EFF" "BVETO_el"
getFlavSyst b_mA140tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh140"  "B_EFF" "BVETO_el"
getFlavSyst b_mA150tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh150"  "B_EFF" "BVETO_el"
getFlavSyst b_mA170tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh170"  "B_EFF" "BVETO_el"
getFlavSyst b_mA200tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh200"  "B_EFF" "BVETO_el"
getFlavSyst b_mA250tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh250"  "B_EFF" "BVETO_el"
getFlavSyst b_mA300tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh300"  "B_EFF" "BVETO_el"
getFlavSyst b_mA350tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh350"  "B_EFF" "BVETO_el"
getFlavSyst b_mA400tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh400"  "B_EFF" "BVETO_el"
getFlavSyst b_mA450tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh450"  "B_EFF" "BVETO_el"
getFlavSyst b_mA500tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh500"  "B_EFF" "BVETO_el"


getJESSyst $FILE_BVETOEle "ATLAS_Bkg_diboson"       "JES" "BVETO_el"
getJESSyst $FILE_BVETOEle "ATLAS_Bkg_singletop"     "JES" "BVETO_el"
getJESSyst $FILE_BVETOEle "ATLAS_Bkg_top"           "JES" "BVETO_el"
getJESSyst $FILE_BVETOEle "ATLAS_Bkg_QCDLH"         "JES" "BVETO_el"
getJESSyst $FILE_BVETOEle "ATLAS_Bkg_Zjets"         "JES" "BVETO_el"
getJESSyst $FILE_BVETOEle "ATLAS_Bkg_W"             "JES" "BVETO_el"
getJESSyst $FILE_BVETOEle "ATLAS_Bkg_Ztau"          "JES" "BVETO_el"

getJESSyst b_mA090tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh090"  "JES" "BVETO_el"
getJESSyst b_mA100tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh100"  "JES" "BVETO_el"
getJESSyst b_mA110tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh110"  "JES" "BVETO_el"
getJESSyst b_mA120tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh120"  "JES" "BVETO_el"
getJESSyst b_mA130tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh130"  "JES" "BVETO_el"
getJESSyst b_mA140tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh140"  "JES" "BVETO_el"
getJESSyst b_mA150tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh150"  "JES" "BVETO_el"
getJESSyst b_mA170tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh170"  "JES" "BVETO_el"
getJESSyst b_mA200tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh200"  "JES" "BVETO_el"
getJESSyst b_mA250tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh250"  "JES" "BVETO_el"
getJESSyst b_mA300tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh300"  "JES" "BVETO_el"
getJESSyst b_mA350tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh350"  "JES" "BVETO_el"
getJESSyst b_mA400tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh400"  "JES" "BVETO_el"
getJESSyst b_mA450tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh450"  "JES" "BVETO_el"
getJESSyst b_mA500tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh500"  "JES" "BVETO_el"

getJESSyst b_mA090tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh090"  "JES" "BVETO_el"
getJESSyst b_mA100tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh100"  "JES" "BVETO_el"
getJESSyst b_mA110tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh110"  "JES" "BVETO_el"
getJESSyst b_mA120tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh120"  "JES" "BVETO_el"
getJESSyst b_mA130tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh130"  "JES" "BVETO_el"
getJESSyst b_mA140tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh140"  "JES" "BVETO_el"
getJESSyst b_mA150tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh150"  "JES" "BVETO_el"
getJESSyst b_mA170tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh170"  "JES" "BVETO_el"
getJESSyst b_mA200tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh200"  "JES" "BVETO_el"
getJESSyst b_mA250tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh250"  "JES" "BVETO_el"
getJESSyst b_mA300tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh300"  "JES" "BVETO_el"
getJESSyst b_mA350tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh350"  "JES" "BVETO_el"
getJESSyst b_mA400tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh400"  "JES" "BVETO_el"
getJESSyst b_mA450tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh450"  "JES" "BVETO_el"
getJESSyst b_mA500tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh500"  "JES" "BVETO_el"

FILE_BVETOEle="b_mA130tb10_BVETO_mu.xml"

getFlavSyst $FILE_BVETOEle "ATLAS_Bkg_diboson"       "B_EFF" "BVETO_mu"
getFlavSyst $FILE_BVETOEle "ATLAS_Bkg_singletop"     "B_EFF" "BVETO_mu"
getFlavSyst $FILE_BVETOEle "ATLAS_Bkg_top"           "B_EFF" "BVETO_mu"
getFlavSyst $FILE_BVETOEle "ATLAS_Bkg_QCDLH"         "B_EFF" "BVETO_mu"
getFlavSyst $FILE_BVETOEle "ATLAS_Bkg_Zjets"         "B_EFF" "BVETO_mu"
getFlavSyst $FILE_BVETOEle "ATLAS_Bkg_W"             "B_EFF" "BVETO_mu"

getFlavSyst b_mA090tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh090"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA100tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh100"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA110tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh110"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA120tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh120"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA130tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh130"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA140tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh140"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA150tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh150"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA170tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh170"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA200tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh200"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA250tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh250"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA300tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh300"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA350tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh350"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA400tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh400"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA450tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh450"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA500tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh500"  "B_EFF" "BVETO_mu"

getFlavSyst b_mA090tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh090"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA100tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh100"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA110tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh110"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA120tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh120"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA130tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh130"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA140tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh140"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA150tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh150"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA170tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh170"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA200tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh200"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA250tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh250"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA300tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh300"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA350tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh350"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA400tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh400"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA450tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh450"  "B_EFF" "BVETO_mu"
getFlavSyst b_mA500tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh500"  "B_EFF" "BVETO_mu"


getJESSyst $FILE_BVETOEle "ATLAS_Bkg_diboson"       "JES" "BVETO_mu"
getJESSyst $FILE_BVETOEle "ATLAS_Bkg_singletop"     "JES" "BVETO_mu"
getJESSyst $FILE_BVETOEle "ATLAS_Bkg_top"           "JES" "BVETO_mu"
getJESSyst $FILE_BVETOEle "ATLAS_Bkg_QCDLH"         "JES" "BVETO_mu"
getJESSyst $FILE_BVETOEle "ATLAS_Bkg_Zjets"         "JES" "BVETO_mu"
getJESSyst $FILE_BVETOEle "ATLAS_Bkg_W"             "JES" "BVETO_mu"
getJESSyst $FILE_BVETOEle "ATLAS_Bkg_Ztau"          "JES" "BVETO_mu"

getJESSyst b_mA090tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh090"  "JES" "BVETO_mu"
getJESSyst b_mA100tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh100"  "JES" "BVETO_mu"
getJESSyst b_mA110tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh110"  "JES" "BVETO_mu"
getJESSyst b_mA120tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh120"  "JES" "BVETO_mu"
getJESSyst b_mA130tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh130"  "JES" "BVETO_mu"
getJESSyst b_mA140tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh140"  "JES" "BVETO_mu"
getJESSyst b_mA150tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh150"  "JES" "BVETO_mu"
getJESSyst b_mA170tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh170"  "JES" "BVETO_mu"
getJESSyst b_mA200tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh200"  "JES" "BVETO_mu"
getJESSyst b_mA250tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh250"  "JES" "BVETO_mu"
getJESSyst b_mA300tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh300"  "JES" "BVETO_mu"
getJESSyst b_mA350tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh350"  "JES" "BVETO_mu"
getJESSyst b_mA400tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh400"  "JES" "BVETO_mu"
getJESSyst b_mA450tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh450"  "JES" "BVETO_mu"
getJESSyst b_mA500tb10_BVETO_el.xml "ATLAS_Sig_HiggsggAlh500"  "JES" "BVETO_mu"

getJESSyst b_mA090tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh090"  "JES" "BVETO_mu"
getJESSyst b_mA100tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh100"  "JES" "BVETO_mu"
getJESSyst b_mA110tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh110"  "JES" "BVETO_mu"
getJESSyst b_mA120tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh120"  "JES" "BVETO_mu"
getJESSyst b_mA130tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh130"  "JES" "BVETO_mu"
getJESSyst b_mA140tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh140"  "JES" "BVETO_mu"
getJESSyst b_mA150tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh150"  "JES" "BVETO_mu"
getJESSyst b_mA170tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh170"  "JES" "BVETO_mu"
getJESSyst b_mA200tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh200"  "JES" "BVETO_mu"
getJESSyst b_mA250tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh250"  "JES" "BVETO_mu"
getJESSyst b_mA300tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh300"  "JES" "BVETO_mu"
getJESSyst b_mA350tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh350"  "JES" "BVETO_mu"
getJESSyst b_mA400tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh400"  "JES" "BVETO_mu"
getJESSyst b_mA450tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh450"  "JES" "BVETO_mu"
getJESSyst b_mA500tb10_BVETO_el.xml "ATLAS_Sig_HiggsbbAlh500"  "JES" "BVETO_mu"
