#!/bin/bash

FILE="summedUp.txt"

# input: sample name , Channel
function ReplacePart() {
    # JES correction
    theLine=`grep $1 $FILE | grep $2 | grep JES`
    sed -i  '/<Sample Name="'"${1}"'"/,/ <\/Sample>/s%<OverallSys Name="JES".*%'"${theLine}"'%' b_mA*${2}*.xml
    sed -i  '/<Sample Name="'"${1}"'"/,/ <\/Sample>/s%<OverallSys Name="Cluster".*%%' b_mA*${2}*.xml
    sed -i  '/<Sample Name="'"${1}"'"/,/ <\/Sample>/s%<OverallSys Name="METPileUp".*%%' b_mA*${2}*.xml

    # B_EFF correction
#    theLine=`grep $1 $FILE | grep $2 | grep B_EFF`
#    sed -i  '/<Sample Name="'"${1}"'"/,/ <\/Sample>/s%<OverallSys Name="B_EFF".*%'"${theLine}"'%' b_mA*${2}*.xml
#    sed -i  '/<Sample Name="'"${1}"'"/,/ <\/Sample>/s%<OverallSys Name="C_EFF".*%%' b_mA*${2}*.xml
#    sed -i  '/<Sample Name="'"${1}"'"/,/ <\/Sample>/s%<OverallSys Name="L_EFF".*%%' b_mA*${2}*.xml
    

}


sed -i '/JES/d'    b_Denom*xml b_Numer*xml
sed -i '/T_EFF/d'  b_Denom*xml b_Numer*xml
sed -i '/B_EFF/d'  b_Denom*xml b_Numer*xml
sed -i '/C_EFF/d'  b_Denom*xml b_Numer*xml
sed -i '/L_EFF/d'  b_Denom*xml b_Numer*xml
sed -i '/E_EFF/d'  b_Denom*xml b_Numer*xml
sed -i '/EmbIso/d' b_Denom*xml b_Numer*xml
sed -i '/EmbMfs/d' b_Denom*xml b_Numer*xml



# add up the btagging information

ReplacePart "ATLAS_Bkg_diboson"    BVETO_el
ReplacePart "ATLAS_Bkg_singletop"  BVETO_el
ReplacePart "ATLAS_Bkg_top"        BVETO_el
ReplacePart "ATLAS_Bkg_QCDLH"      BVETO_el
ReplacePart "ATLAS_Bkg_Zjets"      BVETO_el
ReplacePart "ATLAS_Bkg_W"          BVETO_el
ReplacePart "ATLAS_Bkg_Ztau"       BVETO_el

ReplacePart "ATLAS_Bkg_diboson"    BVETO_mu
ReplacePart "ATLAS_Bkg_singletop"  BVETO_mu
ReplacePart "ATLAS_Bkg_top"        BVETO_mu
ReplacePart "ATLAS_Bkg_QCDLH"      BVETO_mu
ReplacePart "ATLAS_Bkg_Zjets"      BVETO_mu
ReplacePart "ATLAS_Bkg_W"          BVETO_mu
ReplacePart "ATLAS_Bkg_Ztau"       BVETO_mu


ReplacePart "ATLAS_Bkg_singletop"  BTAG_el
ReplacePart "ATLAS_Bkg_top"        BTAG_el
ReplacePart "ATLAS_Bkg_QCDLH"      BTAG_el
ReplacePart "ATLAS_Bkg_Zjets"      BTAG_el
ReplacePart "ATLAS_Bkg_W"          BTAG_el
ReplacePart "ATLAS_Bkg_Ztau"       BTAG_el


ReplacePart "ATLAS_Bkg_singletop"  BTAG_mu
ReplacePart "ATLAS_Bkg_top"        BTAG_mu
ReplacePart "ATLAS_Bkg_QCDLH"      BTAG_mu
ReplacePart "ATLAS_Bkg_Zjets"      BTAG_mu
ReplacePart "ATLAS_Bkg_W"          BTAG_mu
ReplacePart "ATLAS_Bkg_Ztau"       BTAG_mu

ReplacePart "ATLAS_Sig_HiggsggAlh090"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh100"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh110"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh120"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh130"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh140"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh150"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh170"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh200"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh250"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh300"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh350"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh400"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh450"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh500"   "BVETO_mu"

ReplacePart "ATLAS_Sig_HiggsbbAlh090"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh100"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh110"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh120"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh130"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh140"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh150"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh170"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh200"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh250"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh300"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh350"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh400"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh450"   "BVETO_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh500"   "BVETO_mu"


ReplacePart "ATLAS_Sig_HiggsggAlh090"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsggAlh100"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsggAlh110"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsggAlh120"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsggAlh130"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsggAlh140"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsggAlh150"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsggAlh170"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsggAlh200"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsggAlh250"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsggAlh300"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsggAlh350"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsggAlh400"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsggAlh450"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsggAlh500"   "BVETO_el"

ReplacePart "ATLAS_Sig_HiggsbbAlh090"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh100"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh110"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh120"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh130"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh140"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh150"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh170"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh200"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh250"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh300"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh350"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh400"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh450"   "BVETO_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh500"   "BVETO_el"

ReplacePart "ATLAS_Sig_HiggsggAlh090"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh100"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh110"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh120"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh130"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh140"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh150"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh170"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh200"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh250"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh300"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh350"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh400"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh450"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsggAlh500"   "BTAG_mu"
						 
ReplacePart "ATLAS_Sig_HiggsbbAlh090"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh100"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh110"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh120"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh130"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh140"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh150"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh170"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh200"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh250"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh300"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh350"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh400"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh450"   "BTAG_mu"
ReplacePart "ATLAS_Sig_HiggsbbAlh500"   "BTAG_mu"
						 
						 
ReplacePart "ATLAS_Sig_HiggsggAlh090"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsggAlh100"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsggAlh110"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsggAlh120"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsggAlh130"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsggAlh140"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsggAlh150"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsggAlh170"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsggAlh200"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsggAlh250"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsggAlh300"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsggAlh350"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsggAlh400"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsggAlh450"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsggAlh500"   "BTAG_el"
						 
ReplacePart "ATLAS_Sig_HiggsbbAlh090"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh100"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh110"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh120"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh130"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh140"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh150"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh170"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh200"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh250"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh300"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh350"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh400"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh450"   "BTAG_el"
ReplacePart "ATLAS_Sig_HiggsbbAlh500"   "BTAG_el"
