#!/bin/bash

thepath="./workspaces/$1"
theTag="$1"

function runJob() {
    # input: file, mass, fname
    root -b runSig_Factory.C+\(\"${1}\",\"${2}\"\) >& outsig_${theTag}_${3}_${2}.txt &


}

function runMassPointComb() {
    runJob "${thepath}_mA${1}tb${2}_comb_combined_AllSyst_model.root"  mA${1}tb${2} mssm
}


function runMassPoint() {

    runMassPointComb $1 05
    runMassPointComb $1 08
    runMassPointComb $1 10
    runMassPointComb $1 13
    runMassPointComb $1 16
    runMassPointComb $1 20
    runMassPointComb $1 23
    runMassPointComb $1 26
    runMassPointComb $1 30
    runMassPointComb $1 35
    runMassPointComb $1 40
    runMassPointComb $1 45
    runMassPointComb $1 50
    runMassPointComb $1 55
    runMassPointComb $1 60
    runMassPointComb $1 65
    runMassPointComb $1 70
    wait
}

function runGrid() {
    runMassPoint 090
    runMassPoint 100
    runMassPoint 110
    runMassPoint 120
    runMassPoint 130
    runMassPoint 140

    runMassPoint 150
    runMassPoint 170
    runMassPoint 200
    runMassPoint 250
    runMassPoint 300
    runMassPoint 350
    runMassPoint 400
    runMassPoint 450
    runMassPoint 500

}

function runList() {

    for i in ${@}; do
	runMassPoint $i
    done

}


runMassPointComb 130 10
exit
runList ${@}
wait
exit
#runGrid

runMassPoint 090
runMassPoint 100
runMassPoint 110
runMassPoint 120
runMassPoint 130
runMassPoint 140
runMassPoint 150
runMassPoint 170
runMassPoint 200
runMassPoint 250
runMassPoint 300
runMassPoint 350
runMassPoint 400
runMassPoint 450
runMassPoint 500

