 void test() {
   gROOT->Reset();
   gROOT->ProcessLine(".L ~/atlasStyle.C");
   gROOT->ProcessLine("setAtlasStyle()");
//    TGraphAsymmErrors *g  = new TGraphAsymmErrors(); // data observed
//    TGraphAsymmErrors *g0 = new TGraphAsymmErrors(); // data expected
//    TGraphAsymmErrors *g1 = new TGraphAsymmErrors(); // data expected: 1 sigma
//    TGraphAsymmErrors *g2 = new TGraphAsymmErrors(); // data expected: 2 sigma


   TFile *f = new TFile("./root/MM_graphs_ggA_12.root","read");

   TGraphAsymmErrors *g  =  (TGraphAsymmErrors*) f->Get("obs");
   TGraphAsymmErrors *g0 =  (TGraphAsymmErrors*) f->Get("exp");
   TGraphAsymmErrors *g1 =  (TGraphAsymmErrors*) f->Get("onesig");
   TGraphAsymmErrors *g2 =  (TGraphAsymmErrors*) f->Get("twosig");


   TGraph *csg1 = new TGraph(); // data expected

   csg1->SetPoint(0, 90., 8);
   csg1->SetPoint(1,100., 9);
   csg1->SetPoint(2,120., 8);
   csg1->SetPoint(3,130., 6);
   csg1->SetPoint(4,140., 8);
   csg1->SetPoint(5,175.,10);
   csg1->SetPoint(6,200.,11);
   csg1->SetPoint(7,250.,14);
   csg1->SetPoint(8,300.,18);
   csg1->SetPoint(9,350.,22);
   csg1->SetPoint(10,400.,27);
   csg1->SetPoint(11,450.,33);
   csg1->SetPoint(12,500.,40);

   csg1->SetMarkerSize(0.5);
   csg1->SetLineWidth(2);
   csg1->SetLineStyle(4);
   csg1->SetLineColor(4);
   //csg1->Draw("L,same"); // CMS result

   TGraph *sg0 = new TGraph(); // data expected

   sg0->SetPoint(0, 90.,24);
   sg0->SetPoint(1,100.,26);
   sg0->SetPoint(2,110.,20);
   sg0->SetPoint(3,120.,16);
   sg0->SetPoint(4,150.,14);
   sg0->SetPoint(5,170.,14);
   sg0->SetPoint(6,200.,17);
   sg0->SetPoint(7,300.,31);
   sg0->SetPoint(8,350.,38.5);
   sg0->SetPoint(9,400.,52);

   //   sg0->Draw("L,same");
   sg0->SetMarkerSize(0.5);
   sg0->SetLineWidth(2);
   //sg0->Draw("L,same");



   TCanvas *c = new TCanvas();
   g->SetMarkerStyle(20);
   g0->GetYaxis()->SetTitle("tan#beta");
   g0->GetXaxis()->SetTitle("m_{A} [GeV/c^{2}]");
   g0->SetLineStyle(2);
   g1->SetLineStyle(2);
   g2->SetLineStyle(2);
   g0->SetLineWidth(2);
   g1->SetLineWidth(2);
   g2->SetLineWidth(2);
   g1->SetFillColor(kGreen);
   g2->SetFillColor(kYellow);
   g0->GetYaxis()->SetRangeUser(0,70);

   TH1F *h_axes = new TH1F("","", 100, 90, 350);
   h_axes->Fill(-10, 1000);
   h_axes->GetYaxis()->SetTitle("95% upper limit on #sigma #times BR(#phi#rightarrow#mu#mu) [pb]");
   h_axes->GetXaxis()->SetTitle("m_{#phi} [GeV/c^{2}]");

   h_axes->GetYaxis()->SetRangeUser(0.005,5);
   gPad->SetLogy();
   h_axes->SetLineColor(0);
   h_axes->Draw("HIST");
   

   g0->Draw("L,same");
   g2->Draw("E3,same");
   g1->Draw("E3,same");
   g0->Draw("L,same");

   // sg0->Draw("L,same");
   //csg1->Draw("L,same"); // CMS result

   g->Draw("PL,same");
   TLegend *leg = new TLegend(0.15+0.47, 0.55-0.14, 0.45+0.47, 0.77-0.14);
    leg->SetFillColor(kWhite);
    leg->SetFillStyle(0);
    leg->SetLineColor(0);
    g2->SetLineColor(0);
    g1->SetLineColor(0);
    g2->SetLineStyle(0);
    g1->SetLineStyle(0);
    leg->AddEntry(g, "Observed CLs", "LP");
    leg->AddEntry(g0, "Expected CLs", "L");
    leg->AddEntry(g1,"1 #sigma", "F");
    leg->AddEntry(g2,"2 #sigma", "F");

    // leg->AddEntry(sg0,"ATLAS Exp. 1fb^{-1}", "L");
    // leg->AddEntry(csg1,"CMS Exp. 4.6fb^{-1} (lh+ll) Dec11", "L");
    //leg->AddEntry(csg1,"CMS Exp. (lh+ll) Dec11", "L");

    leg->Draw("same");
    TLatex *l = new TLatex;
    l->SetNDC();
    l->SetTextFont(72);
    l->SetTextColor(1);
    l->SetTextSize(0.04);
    //    l->DrawLatex(0.15,0.87,"#splitline{ATLAS Internal, Preliminary, 2011}{4.66 fb^{-1}, #sqrt{s}=7 TeV}");
    l->DrawLatex(0.15+0.4,0.87,"ATLAS Internal, 2011");
    TLatex *l1 = new TLatex;
    l1->SetNDC();
    l1->SetTextFont(72);
    l1->SetTextColor(1);
    l1->SetTextSize(0.04);
    l1->DrawLatex(0.15+0.2,0.80,"#phi#rightarrow #mu#mu channel, gluon-gluon fusion");
    TLatex *l2 = new TLatex;
    l2->SetNDC();
    l2->SetTextFont(72);
    l2->SetTextColor(1);
    l2->SetTextSize(0.04);
    l1->DrawLatex(0.15+0.4,0.70,"#int L dt = 4.7 fb^{-1}, #sqrt{s}=7 TeV");

    gPad->RedrawAxis();
    c->Print("limit_mumu_gga.eps");
    c->Print("limit_mumu_gga.png");
}
