void update_rounding(TString filename, TString inputfolder, TString outputfolder){
  using namespace std;
  using namespace RooFit;
  using namespace RooStats;

  TString workspacename = "combined";
  //if(filename.Contains("HHChannelAtLeastOneBJet")){
  //  workspacename = "HHChannelAtLeastOneBJet";  
  //}
  //if(filename.Contains("HHChannelNoBJetKinSel")){
  //  workspacename = "HHChannelNoBJetKinSel";  
  // }
  //if(filename.Contains("HHChannelMMCEfficiency")){
  //  workspacename = "HHChannelMMCEfficiency";
  //}

  TString inputname=inputfolder+"/"+filename;
  cout << "Reading datasetname = obsData modelname = ModelConfig from workspacename = " << workspacename << " in fname = " << inputname << endl;
  TFile* file=TFile::Open(inputname); // input file name
  RooWorkspace* ws = (RooWorkspace*)file->Get(workspacename);
  ModelConfig* mc  = (ModelConfig*)ws->obj("ModelConfig");
  RooDataSet* data = (RooDataSet*)ws->data("obsData");
  //
  if (mc->GetNuisanceParameters()) {
    TIterator* nItr = mc->GetNuisanceParameters()->createIterator();
    RooRealVar* var;
    while ((var = (RooRealVar*)nItr->Next())) {
      string poisName = string(var->GetName()) + "_constraint";
      if (poisName.find("gamma_stat") == string::npos) continue;
      RooPoisson* pois = (RooPoisson*)ws->pdf(poisName.c_str());
      if (!pois) {
	cout << "ERROR::Couldn't find corresponding poisson for var = " << var->GetName() << endl;
	exit(1);
      }
      cout << "setNoRounding=true for var = " << var->GetName() << endl;
      pois->setNoRounding(true);
    }
  }
  //

  TString outputname=outputfolder+"/"+filename;
  cout << "Writing to outputname = " << outputname << endl;
  ws->writeToFile(outputname); // output file name
  file->Close();
}


void runUpdater() {
  // resultsAlaNikosTop/TauTau_TopLevel_LHHHEMMM_combined_mA130tb10_combined_AllSYS_model.root
  update_rounding("mssm_mA130tb10_comb_combined_AllSyst_model.root","results/","resultsupdated/");

}

void updateMass(TString mass) {

  int n_tb = 17;
  TString tb[] = {"05","08","10","13","16","20","23","26","30","35","40","45","50","55","60","65","70"};


  int jstart = 0;
  if (mass == "450") jstart=6;
  if (mass == "500") jstart=8;
  for (int j=jstart; j<n_tb; ++j) {
    update_rounding("mssm_mA"+mass+"tb"+tb[j]+"_comb_combined_AllSyst_model.root", 
		    "resultsV7/", "resultsV7updated/");
  }


}

void runMass1() {
  updateMass("090");
  updateMass("100");
  updateMass("110");
  updateMass("120");
}

void runMass2() {
  updateMass("130");
  updateMass("140");
  updateMass("150");
  updateMass("170");
}

void runMass3() {
  updateMass("200");
  updateMass("200");
  updateMass("250");
  updateMass("300");
}

void runMass4() {
  updateMass("350");
  updateMass("400");
  updateMass("450");
  updateMass("500");
}


void runUpdater1() {
  int n_ma = 15;
  TString ma[] = {"090", "100", "110","120","130","140","150","170","200",
		  "250","300","350", "400", "450","500"};
  int n_tb = 17;
  TString tb[] = {"05","08","10","13","16","20","23","26","30","35","40","45","50","55","60","65","70"};


  for (int i=0; i<n_ma; ++i) {
    int jstart = 0;
    if (ma[i] == "450") jstart=6;
    if (ma[i] == "500") jstart=8;
    for (int j=jstart; j<n_tb; ++j) {
      update_rounding("mssm_mA"+ma[i]+"tb"+tb[j]+"_comb_combined_AllSyst_model.root", 
		      "resultsV7/", "resultsV7updated/");
    }
  }


}
