 void test() {
   gROOT->Reset();
   gROOT->ProcessLine(".L ~/atlasStyle.C");
   gROOT->ProcessLine("setAtlasStyle()");
   TGraphAsymmErrors *g  = new TGraphAsymmErrors(); // data observed
   TGraphAsymmErrors *g0 = new TGraphAsymmErrors(); // data expected
   TGraphAsymmErrors *g1 = new TGraphAsymmErrors(); // data expected: 1 sigma
   TGraphAsymmErrors *g2 = new TGraphAsymmErrors(); // data expected: 2 sigma

 // Summary: 90 21.00 18.05 25.89 21.61 15.16 12.84 
 g->SetPoint(0, 90,  21.00); 
 g0->SetPoint(0, 90, 18.05); g1->SetPoint(0, 90, 18.05);g2->SetPoint(0, 90, 18.05);
 g1->SetPointError(0, 0,0, 18.05-15.16, 21.61-18.05); 
 g2->SetPointError(0, 0,0, 18.05-12.84, 25.89-18.05); 
 // Summary: 100 15.25 18.18 26.00 21.76 15.20 12.83 
 g->SetPoint(1, 100,  15.25); 
 g0->SetPoint(1, 100, 18.18); g1->SetPoint(1, 100, 18.18);g2->SetPoint(1, 100, 18.18);
 g1->SetPointError(1, 0,0, 18.18-15.20, 21.76-18.18); 
 g2->SetPointError(1, 0,0, 18.18-12.83, 26.00-18.18); 
 // Summary: 110 12.02 15.05 22.57 18.57 12.41 10.17 
 g->SetPoint(2, 110,  12.02); 
 g0->SetPoint(2, 110, 15.05); g1->SetPoint(2, 110, 15.05);g2->SetPoint(2, 110, 15.05);
 g1->SetPointError(2, 0,0, 15.05-12.41, 18.57-15.05); 
 g2->SetPointError(2, 0,0, 15.05-10.17, 22.57-15.05); 
 // Summary: 120 11.39 13.19 19.92 16.24 11.44 9.60 
 g->SetPoint(3, 120,  11.39); 
 g0->SetPoint(3, 120, 13.19); g1->SetPoint(3, 120, 13.19);g2->SetPoint(3, 120, 13.19);
 g1->SetPointError(3, 0,0, 13.19-11.44, 16.24-13.19); 
 g2->SetPointError(3, 0,0, 13.19-9.60, 19.92-13.19); 
 // Summary: 130 10.98 12.77 18.94 15.64 10.55 8.75 
 g->SetPoint(4, 130,  10.98); 
 g0->SetPoint(4, 130, 12.77); g1->SetPoint(4, 130, 12.77);g2->SetPoint(4, 130, 12.77);
 g1->SetPointError(4, 0,0, 12.77-10.55, 15.64-12.77); 
 g2->SetPointError(4, 0,0, 12.77-8.75, 18.94-12.77); 
 // Summary: 140 11.00 12.28 18.38 15.00 9.95 8.32 
 g->SetPoint(5, 140,  11.00); 
 g0->SetPoint(5, 140, 12.28); g1->SetPoint(5, 140, 12.28);g2->SetPoint(5, 140, 12.28);
 g1->SetPointError(5, 0,0, 12.28-9.95, 15.00-12.28); 
 g2->SetPointError(5, 0,0, 12.28-8.32, 18.38-12.28); 
 // Summary: 150 11.15 12.31 18.33 15.00 9.94 8.85 
 g->SetPoint(6, 150,  11.15); 
 g0->SetPoint(6, 150, 12.31); g1->SetPoint(6, 150, 12.31);g2->SetPoint(6, 150, 12.31);
 g1->SetPointError(6, 0,0, 12.31-9.94, 15.00-12.31); 
 g2->SetPointError(6, 0,0, 12.31-8.85, 18.33-12.31); 
 // Summary: 170 10.46 12.62 18.58 15.30 10.52 8.82 
 g->SetPoint(7, 170,  10.46); 
 g0->SetPoint(7, 170, 12.62); g1->SetPoint(7, 170, 12.62);g2->SetPoint(7, 170, 12.62);
 g1->SetPointError(7, 0,0, 12.62-10.52, 15.30-12.62); 
 g2->SetPointError(7, 0,0, 12.62-8.82, 18.58-12.62); 
 // Summary: 200 12.95 14.88 21.00 17.82 12.54 10.82 
 g->SetPoint(8, 200,  12.95); 
 g0->SetPoint(8, 200, 14.88); g1->SetPoint(8, 200, 14.88);g2->SetPoint(8, 200, 14.88);
 g1->SetPointError(8, 0,0, 14.88-12.54, 17.82-14.88); 
 g2->SetPointError(8, 0,0, 14.88-10.82, 21.00-14.88); 
 // Summary: 250 16.62 18.85 26.00 22.13 15.94 14.05 
 g->SetPoint(9, 250,  16.62); 
 g0->SetPoint(9, 250, 18.85); g1->SetPoint(9, 250, 18.85);g2->SetPoint(9, 250, 18.85);
 g1->SetPointError(9, 0,0, 18.85-15.94, 22.13-18.85); 
 g2->SetPointError(9, 0,0, 18.85-14.05, 26.00-18.85); 
 // Summary: 300 22.91 24.67 34.17 28.91 21.35 18.93 
 g->SetPoint(10, 300,  22.91); 
 g0->SetPoint(10, 300, 24.67); g1->SetPoint(10, 300, 24.67);g2->SetPoint(10, 300, 24.67);
 g1->SetPointError(10, 0,0, 24.67-21.35, 28.91-24.67); 
 g2->SetPointError(10, 0,0, 24.67-18.93, 34.17-24.67); 
 // Summary: 350 32.12 30.83 42.50 36.25 26.80 23.67 
 g->SetPoint(11, 350,  32.12); 
 g0->SetPoint(11, 350, 30.83); g1->SetPoint(11, 350, 30.83);g2->SetPoint(11, 350, 30.83);
 g1->SetPointError(11, 0,0, 30.83-26.80, 36.25-30.83); 
 g2->SetPointError(11, 0,0, 30.83-23.67, 42.50-30.83); 
 // Summary: 400 39.85 37.24 51.00 43.57 32.29 28.51 
 g->SetPoint(12, 400,  39.85); 
 g0->SetPoint(12, 400, 37.24); g1->SetPoint(12, 400, 37.24);g2->SetPoint(12, 400, 37.24);
 g1->SetPointError(12, 0,0, 37.24-32.29, 43.57-37.24); 
 g2->SetPointError(12, 0,0, 37.24-28.51, 51.00-37.24); 
 // Summary: 450 51.00 46.96 64.74 55.00 40.62 35.89 
 g->SetPoint(13, 450,  51.00); 
 g0->SetPoint(13, 450, 46.96); g1->SetPoint(13, 450, 46.96);g2->SetPoint(13, 450, 46.96);
 g1->SetPointError(13, 0,0, 46.96-40.62, 55.00-46.96); 
 g2->SetPointError(13, 0,0, 46.96-35.89, 64.74-46.96); 
 // Summary: 500 64.21 58.75 77.60 68.82 50.75 44.67 
 g->SetPoint(14, 500,  64.21); 
 g0->SetPoint(14, 500, 58.75); g1->SetPoint(14, 500, 58.75);g2->SetPoint(14, 500, 58.75);
 g1->SetPointError(14, 0,0, 58.75-50.75, 68.82-58.75); 
 g2->SetPointError(14, 0,0, 58.75-44.67, 77.60-58.75); 
/*
Output for sample comb,all and mass 90
  5      5.91   5.42  10.92   7.74   3.90   2.91 
  8      4.94   3.96   8.20   5.72   2.85   2.13 
 10      3.74   2.86   6.03   4.16   2.06   1.53 
 13      2.47   1.81   3.87   2.65   1.31   0.97 
 16      1.68   1.22   2.62   1.79   0.88   0.66 
 20      1.09   0.79   1.68   1.15   0.57   0.42 
 23      0.82   0.59   1.27   0.87   0.43   0.32 
 26      0.64   0.46   0.99   0.68   0.33   0.25 
 30      0.48   0.35   0.74   0.51   0.25   0.19 
 35      0.35   0.25   0.54   0.37   0.18   0.14 
Limits: 21.00  18.05  25.89  21.61  15.16  12.84  comb all 90
 Output for sample comb,all and mass 100
  5      4.78   5.47  11.04   7.80   3.94   2.94 
  8      2.64   3.74   7.57   5.35   2.69   2.01 
 10      1.97   2.77   5.67   3.98   2.00   1.49 
 13      1.30   1.81   3.76   2.61   1.30   0.97 
 16      0.90   1.24   2.59   1.79   0.89   0.66 
 20      0.60   0.80   1.69   1.17   0.58   0.43 
 23      0.45   0.61   1.28   0.88   0.44   0.33 
 26      0.36   0.48   1.00   0.69   0.34   0.26 
 30      0.27   0.36   0.75   0.52   0.26   0.19 
 35      0.20   0.26   0.55   0.38   0.19   0.14 
Limits: 15.25  18.18  26.00  21.76  15.20  12.83  comb all 100
 Output for sample comb,all and mass 110
  5      3.53   4.80   9.68   6.84   3.46   2.58 
  8      2.31   3.31   6.69   4.72   2.38   1.77 
 10      1.31   1.90   3.93   2.74   1.37   1.02 
 13      0.85   1.26   2.62   1.82   0.91   0.67 
 16      0.60   0.88   1.85   1.27   0.63   0.47 
 20      0.40   0.59   1.24   0.85   0.42   0.31 
 23      0.31   0.45   0.96   0.66   0.32   0.24 
 26      0.24   0.36   0.76   0.52   0.26   0.19 
 30      0.18   0.27   0.58   0.39   0.19   0.14 
 35      0.13   0.20   0.42   0.29   0.14   0.11 
Limits: 12.02  15.05  22.57  18.57  12.41  10.17  comb all 110
 Output for sample comb,all and mass 120
  5      3.02   4.20   8.52   6.01   3.03   2.26 
  8      1.71   2.38   4.85   3.40   1.71   1.28 
 10      1.25   1.74   3.58   2.50   1.25   0.93 
 13      0.71   1.02   2.12   1.46   0.73   0.55 
 16      0.49   0.71   1.48   1.02   0.51   0.38 
 20      0.33   0.47   0.99   0.68   0.34   0.25 
 23      0.25   0.36   0.77   0.53   0.26   0.19 
 26      0.20   0.29   0.61   0.42   0.21   0.15 
 30      0.15   0.22   0.46   0.32   0.16   0.12 
 35      0.11   0.16   0.34   0.23   0.12   0.09 
Limits: 11.39  13.19  19.92  16.24  11.44   9.60  comb all 120
 Output for sample comb,all and mass 130
  5      2.93   3.69   7.36   5.24   2.66   1.98 
  8      1.58   2.09   4.23   2.97   1.50   1.12 
 10      1.13   1.49   3.03   2.12   1.07   0.80 
 13      0.73   0.96   1.96   1.37   0.69   0.52 
 16      0.51   0.66   1.36   0.95   0.48   0.35 
 20      0.32   0.42   0.87   0.60   0.30   0.23 
 23      0.25   0.32   0.67   0.46   0.23   0.17 
 26      0.20   0.26   0.53   0.37   0.18   0.14 
 30      0.15   0.19   0.40   0.28   0.14   0.10 
 35      0.11   0.14   0.29   0.20   0.10   0.08 
Limits: 10.98  12.77  18.94  15.64  10.55   8.75  comb all 130
 Output for sample comb,all and mass 140
  5      3.26   4.10   8.18   5.82   2.95   2.20 
  8      1.61   1.96   3.95   2.79   1.41   1.05 
 10      1.14   1.38   2.79   1.97   0.99   0.74 
 13      0.72   0.88   1.80   1.26   0.64   0.47 
 16      0.51   0.61   1.25   0.87   0.44   0.33 
 20      0.34   0.40   0.83   0.58   0.29   0.22 
 23      0.26   0.31   0.63   0.44   0.22   0.17 
 26      0.20   0.24   0.50   0.35   0.18   0.13 
 30      0.15   0.18   0.38   0.26   0.13   0.10 
 35      0.11   0.14   0.28   0.19   0.10   0.07 
Limits: 11.00  12.28  18.38  15.00   9.95   8.32  comb all 140
 Output for sample comb,all and mass 150
  5      2.74   3.69   7.36   5.25   2.66   1.98 
  8      1.86   2.24   4.51   3.18   1.61   1.20 
 10      1.15   1.37   2.75   1.94   0.98   0.73 
 13      0.76   0.89   1.80   1.26   0.64   0.48 
 16      0.53   0.61   1.25   0.87   0.44   0.33 
 20      0.35   0.40   0.82   0.58   0.29   0.22 
 23      0.27   0.31   0.63   0.44   0.22   0.17 
 26      0.21   0.24   0.50   0.35   0.18   0.13 
Limits: 11.15  12.31  18.33  15.00   9.94   8.85  comb all 150
 Output for sample comb,all and mass 170
  5      3.66   5.42  10.83   7.68   3.90   2.91 
  8      1.51   2.13   4.28   3.04   1.54   1.14 
 10      1.06   1.49   3.01   2.13   1.07   0.80 
 13      0.67   0.93   1.89   1.33   0.67   0.50 
 16      0.46   0.63   1.29   0.90   0.45   0.34 
 20      0.30   0.41   0.84   0.59   0.29   0.22 
 23      0.23   0.31   0.64   0.45   0.22   0.17 
 26      0.18   0.24   0.50   0.35   0.18   0.13 
Limits: 10.46  12.62  18.58  15.30  10.52   8.82  comb all 170
 Output for sample comb,all and mass 200
  5      4.98   7.42  14.78  10.57   5.34   3.98 
  8      2.25   3.05   6.09   4.35   2.20   1.64 
 10      1.59   2.09   4.20   2.98   1.50   1.12 
 13      0.99   1.27   2.56   1.81   0.91   0.68 
 16      0.67   0.84   1.70   1.20   0.60   0.45 
 20      0.44   0.53   1.09   0.76   0.39   0.29 
 23      0.33   0.40   0.82   0.57   0.29   0.22 
 26      0.26   0.31   0.64   0.45   0.23   0.17 
Limits: 12.95  14.88  21.00  17.82  12.54  10.82  comb all 200
 Output for sample comb,all and mass 250
 10      2.55   3.56   7.11   5.03   2.57   1.91 
 13      1.60   2.12   4.29   3.03   1.53   1.14 
 16      1.06   1.37   2.78   1.95   0.99   0.74 
 20      0.67   0.85   1.74   1.22   0.61   0.46 
 23      0.51   0.64   1.30   0.91   0.46   0.34 
 26      0.40   0.49   1.00   0.70   0.35   0.26 
 30      0.30   0.37   0.75   0.52   0.26   0.20 
 35      0.22   0.27   0.54   0.38   0.19   0.14 
 40      0.17   0.20   0.41   0.29   0.15   0.11 
Limits: 16.62  18.85  26.00  22.13  15.94  14.05  comb all 250
 Output for sample comb,all and mass 300
 13      3.22   4.16   8.27   5.92   3.00   2.23 
 16      2.16   2.63   5.30   3.76   1.90   1.41 
 20      1.34   1.58   3.20   2.23   1.14   0.85 
 23      0.99   1.15   2.34   1.63   0.83   0.62 
 26      0.77   0.88   1.78   1.24   0.63   0.47 
 30      0.57   0.64   1.30   0.91   0.46   0.34 
 35      0.41   0.46   0.94   0.66   0.33   0.25 
 40      0.31   0.35   0.71   0.49   0.25   0.19 
 45      0.24   0.27   0.55   0.39   0.20   0.15 
Limits: 22.91  24.67  34.17  28.91  21.35  18.93  comb all 300
 Output for sample comb,all and mass 350
 20      2.77   2.74   5.56   3.92   1.98   1.47 
 23      2.04   1.97   4.00   2.79   1.42   1.06 
 26      1.56   1.48   2.99   2.11   1.06   0.79 
 30      1.14   1.05   2.16   1.51   0.76   0.56 
 35      0.81   0.75   1.52   1.07   0.54   0.40 
 40      0.61   0.55   1.13   0.79   0.40   0.30 
 45      0.47   0.43   0.87   0.61   0.31   0.23 
 50      0.38   0.34   0.69   0.49   0.25   0.18 
 55      0.31   0.28   0.57   0.40   0.20   0.15 
 60      0.26   0.23   0.47   0.33   0.17   0.12 
Limits: 32.12  30.83  42.50  36.25  26.80  23.67  comb all 350
 Output for sample comb,all and mass 400
 23      3.29   3.04   6.12   4.31   2.19   1.63 
 26      2.53   2.28   4.60   3.25   1.64   1.22 
 30      1.85   1.62   3.29   2.32   1.16   0.87 
 35      1.32   1.13   2.31   1.62   0.81   0.61 
 40      0.99   0.84   1.71   1.20   0.60   0.45 
 45      0.76   0.64   1.31   0.92   0.46   0.34 
 50      0.61   0.51   1.04   0.73   0.37   0.27 
 55      0.50   0.41   0.84   0.59   0.30   0.22 
 60      0.41   0.34   0.70   0.49   0.25   0.18 
 65      0.35   0.29   0.59   0.41   0.21   0.16 
 70      0.30   0.25   0.50   0.35   0.18   0.13 
Limits: 39.85  37.24  51.00  43.57  32.29  28.51  comb all 400
 Output for sample comb,all and mass 450
 30      3.18   2.83   5.73   4.04   2.04   1.52 
 35      2.28   1.95   3.99   2.81   1.41   1.05 
 40      1.70   1.43   2.94   2.05   1.03   0.77 
 45      1.31   1.09   2.24   1.56   0.79   0.59 
 50      1.04   0.86   1.75   1.24   0.62   0.46 
 55      0.84   0.69   1.42   1.00   0.50   0.37 
 60      0.70   0.57   1.18   0.82   0.41   0.31 
 65      0.59   0.48   0.99   0.69   0.35   0.26 
 70      0.50   0.41   0.84   0.58   0.29   0.22 
Limits: 51.00  46.96  64.74  55.00  40.62  35.89  comb all 450
 Output for sample comb,all and mass 500
 40      2.79   2.39   4.89   3.43   1.72   1.28 
 45      2.16   1.82   3.74   2.62   1.31   0.98 
 50      1.72   1.43   2.94   2.06   1.03   0.77 
 55      1.40   1.15   2.37   1.66   0.83   0.62 
 60      1.16   0.95   1.94   1.36   0.68   0.51 
 65      0.97   0.79   1.63   1.13   0.57   0.42 
 70      0.83   0.67   1.38   0.96   0.48   0.36 
eP2Limit extrapolation is done to 77.600000000
Limits: 64.21  58.75  77.60  68.82  50.75  44.67  comb all 500
 --
Limits: 21.00  18.05  25.89  21.61  15.16  12.84  comb all 90
Limits: 15.25  18.18  26.00  21.76  15.20  12.83  comb all 100
Limits: 12.02  15.05  22.57  18.57  12.41  10.17  comb all 110
Limits: 11.39  13.19  19.92  16.24  11.44   9.60  comb all 120
Limits: 10.98  12.77  18.94  15.64  10.55   8.75  comb all 130
Limits: 11.00  12.28  18.38  15.00   9.95   8.32  comb all 140
Limits: 11.15  12.31  18.33  15.00   9.94   8.85  comb all 150
Limits: 10.46  12.62  18.58  15.30  10.52   8.82  comb all 170
Limits: 12.95  14.88  21.00  17.82  12.54  10.82  comb all 200
Limits: 16.62  18.85  26.00  22.13  15.94  14.05  comb all 250
Limits: 22.91  24.67  34.17  28.91  21.35  18.93  comb all 300
Limits: 32.12  30.83  42.50  36.25  26.80  23.67  comb all 350
Limits: 39.85  37.24  51.00  43.57  32.29  28.51  comb all 400
Limits: 51.00  46.96  64.74  55.00  40.62  35.89  comb all 450
Limits: 64.21  58.75  77.60  68.82  50.75  44.67  comb all 500
*/
// Warning: results may be extrapolated

   TGraph *csg1 = new TGraph(); // data expected

   csg1->SetPoint(0, 90., 8);
   csg1->SetPoint(1,100., 9);
   csg1->SetPoint(2,120., 8);
   csg1->SetPoint(3,130., 6);
   csg1->SetPoint(4,140., 8);
   csg1->SetPoint(5,175.,10);
   csg1->SetPoint(6,200.,11);
   csg1->SetPoint(7,250.,14);
   csg1->SetPoint(8,300.,18);
   csg1->SetPoint(9,350.,22);
   csg1->SetPoint(10,400.,27);
   csg1->SetPoint(11,450.,33);
   csg1->SetPoint(12,500.,40);

   csg1->SetMarkerSize(0.5);
   csg1->SetLineWidth(2);
   csg1->SetLineStyle(4);
   csg1->SetLineColor(4);
   //csg1->Draw("L,same"); // CMS result

   TGraph *sg0 = new TGraph(); // data expected

   sg0->SetPoint(0, 90.,24);
   sg0->SetPoint(1,100.,26);
   sg0->SetPoint(2,110.,20);
   sg0->SetPoint(3,120.,16);
   sg0->SetPoint(4,150.,14);
   sg0->SetPoint(5,170.,14);
   sg0->SetPoint(6,200.,17);
   sg0->SetPoint(7,300.,31);
   sg0->SetPoint(8,350.,38.5);
   sg0->SetPoint(9,400.,52);

   //   sg0->Draw("L,same");
   sg0->SetMarkerSize(0.5);
   sg0->SetLineWidth(2);
   //sg0->Draw("L,same");



   TCanvas *c = new TCanvas("c","c",600,600);
   g->SetMarkerStyle(20);
   g0->GetYaxis()->SetTitle("tan#beta");
   g0->GetXaxis()->SetTitle("m_{A} [GeV/c^{2}]");
   g0->SetLineStyle(2);
   g1->SetLineStyle(2);
   g2->SetLineStyle(2);
   g0->SetLineWidth(2);
   g1->SetLineWidth(2);
   g2->SetLineWidth(2);
   g1->SetFillColor(kGreen);
   g2->SetFillColor(kYellow);
   g0->GetYaxis()->SetRangeUser(0,70);

   TH1F *h_axes = new TH1F("","", 100, 90, 500);
   h_axes->Fill(-10, 1000);
   h_axes->GetYaxis()->SetTitle("tan#beta");
   h_axes->GetXaxis()->SetTitle("m_{A} [GeV/c^{2}]");

   h_axes->GetYaxis()->SetRangeUser(0,60);
   h_axes->SetLineColor(0);
   h_axes->Draw("HIST");
   

   g0->Draw("L,same");
   g2->Draw("E3,same");
   g1->Draw("E3,same");
   g0->Draw("L,same");

   // sg0->Draw("L,same");
   //csg1->Draw("L,same"); // CMS result

   g->Draw("PL,same");
   TLegend *leg = new TLegend(0.15+0.47, 0.55-0.33, 0.45+0.47, 0.77-0.33);
    leg->SetFillColor(kWhite);
    leg->SetFillStyle(0);
    leg->SetLineColor(0);
    g2->SetLineColor(0);
    g1->SetLineColor(0);
    g2->SetLineStyle(0);
    g1->SetLineStyle(0);
    leg->AddEntry(g, "Observed CLs", "LP");
    leg->AddEntry(g0, "Expected CLs", "L");
    leg->AddEntry(g1,"1 #sigma", "F");
    leg->AddEntry(g2,"2 #sigma", "F");

    // leg->AddEntry(sg0,"ATLAS Exp. 1fb^{-1}", "L");
    // leg->AddEntry(csg1,"CMS Exp. 4.6fb^{-1} (lh+ll) Dec11", "L");
    //leg->AddEntry(csg1,"CMS Exp. (lh+ll) Dec11", "L");

    leg->Draw("same");
    TLatex *l = new TLatex;
    l->SetNDC();
    l->SetTextFont(72);
    l->SetTextColor(1);
    l->SetTextSize(0.04);
    //    l->DrawLatex(0.15,0.87,"#splitline{ATLAS Internal, Preliminary, 2011}{4.66 fb^{-1}, #sqrt{s}=7 TeV}");
    l->DrawLatex(0.15,0.87,"ATLAS Internal, 2011");
    TLatex *l1 = new TLatex;
    l1->SetNDC();
    l1->SetTextFont(72);
    l1->SetTextColor(1);
    l1->SetTextSize(0.04);
    l1->DrawLatex(0.15,0.81,"H#rightarrow #tau_{lep}#tau_{had}, m_{h}^{max} scenario");
    TLatex *l2 = new TLatex;
    l2->SetNDC();
    l2->SetTextFont(72);
    l2->SetTextColor(1);
    l2->SetTextSize(0.04);
    l1->DrawLatex(0.15,0.73,"#int L dt = 4.7 fb^{-1}, #sqrt{s}=7 TeV");

    gPad->RedrawAxis();
    c->Print("limit_lh.eps");
    c->Print("limit_lh.png");

    TString folder="LH_combined";
    TString filename=folder+".root";
    TFile *file=new TFile(filename,"RECREATE");
    file->mkdir(folder);
    file->cd(folder);
    TGraph *obs=(TGraph*)g->Clone();
    obs->SetName("Observed");
    gDirectory->Append(obs);
    TGraph *exp=(TGraph*)g0->Clone();
    exp->SetName("Expected");
    gDirectory->Append(exp);
    g1->SetName("Expected1sigma");
    gDirectory->Append(g1);
    g2->SetName("Expected2sigma");
    gDirectory->Append(g2);
    file->Write();
    file->Close();
}
