 void test() {
   gROOT->Reset();
   gROOT->ProcessLine(".L ~/atlasStyle.C");
   gROOT->ProcessLine("setAtlasStyle()");
   TGraphAsymmErrors *g  = new TGraphAsymmErrors(); // data observed
   TGraphAsymmErrors *g0 = new TGraphAsymmErrors(); // data expected
   TGraphAsymmErrors *g1 = new TGraphAsymmErrors(); // data expected: 1 sigma
   TGraphAsymmErrors *g2 = new TGraphAsymmErrors(); // data expected: 2 sigma

 // Summary: 90 18.30 16.32 24.25 19.85 13.83 11.90 
 g->SetPoint(0, 90,  18.30); 
 g0->SetPoint(0, 90, 16.32); g1->SetPoint(0, 90, 16.32);g2->SetPoint(0, 90, 16.32);
 g1->SetPointError(0, 0,0, 16.32-13.83, 19.85-16.32); 
 g2->SetPointError(0, 0,0, 16.32-11.90, 24.25-16.32); 
 // Summary: 100 12.74 15.37 22.40 18.78 12.84 10.95 
 g->SetPoint(1, 100,  12.74); 
 g0->SetPoint(1, 100, 15.37); g1->SetPoint(1, 100, 15.37);g2->SetPoint(1, 100, 15.37);
 g1->SetPointError(1, 0,0, 15.37-12.84, 18.78-15.37); 
 g2->SetPointError(1, 0,0, 15.37-10.95, 22.40-15.37); 
 // Summary: 110 11.14 13.55 20.38 16.78 11.29 9.61 
 g->SetPoint(2, 110,  11.14); 
 g0->SetPoint(2, 110, 13.55); g1->SetPoint(2, 110, 13.55);g2->SetPoint(2, 110, 13.55);
 g1->SetPointError(2, 0,0, 13.55-11.29, 16.78-13.55); 
 g2->SetPointError(2, 0,0, 13.55-9.61, 20.38-13.55); 
 // Summary: 120 11.26 11.81 17.37 14.20 9.72 7.92 
 g->SetPoint(3, 120,  11.26); 
 g0->SetPoint(3, 120, 11.81); g1->SetPoint(3, 120, 11.81);g2->SetPoint(3, 120, 11.81);
 g1->SetPointError(3, 0,0, 11.81-9.72, 14.20-11.81); 
 g2->SetPointError(3, 0,0, 11.81-7.92, 17.37-11.81); 
 // Summary: 130 11.10 11.21 16.44 13.64 9.06 7.48 
 g->SetPoint(4, 130,  11.10); 
 g0->SetPoint(4, 130, 11.21); g1->SetPoint(4, 130, 11.21);g2->SetPoint(4, 130, 11.21);
 g1->SetPointError(4, 0,0, 11.21-9.06, 13.64-11.21); 
 g2->SetPointError(4, 0,0, 11.21-7.48, 16.44-11.21); 
 // Summary: 140 12.14 10.32 15.36 12.66 8.39 7.21 
 g->SetPoint(5, 140,  12.14); 
 g0->SetPoint(5, 140, 10.32); g1->SetPoint(5, 140, 10.32);g2->SetPoint(5, 140, 10.32);
 g1->SetPointError(5, 0,0, 10.32-8.39, 12.66-10.32); 
 g2->SetPointError(5, 0,0, 10.32-7.21, 15.36-10.32); 
 // Summary: 150 12.23 10.62 15.65 12.89 9.06 7.71 
 g->SetPoint(6, 150,  12.23); 
 g0->SetPoint(6, 150, 10.62); g1->SetPoint(6, 150, 10.62);g2->SetPoint(6, 150, 10.62);
 g1->SetPointError(6, 0,0, 10.62-9.06, 12.89-10.62); 
 g2->SetPointError(6, 0,0, 10.62-7.71, 15.65-10.62); 
 // Summary: 170 10.31 11.27 16.00 13.44 9.26 7.83 
 g->SetPoint(7, 170,  10.31); 
 g0->SetPoint(7, 170, 11.27); g1->SetPoint(7, 170, 11.27);g2->SetPoint(7, 170, 11.27);
 g1->SetPointError(7, 0,0, 11.27-9.26, 13.44-11.27); 
 g2->SetPointError(7, 0,0, 11.27-7.83, 16.00-11.27); 
 // Summary: 200 12.02 13.26 19.02 15.82 11.41 9.64 
 g->SetPoint(8, 200,  12.02); 
 g0->SetPoint(8, 200, 13.26); g1->SetPoint(8, 200, 13.26);g2->SetPoint(8, 200, 13.26);
 g1->SetPointError(8, 0,0, 13.26-11.41, 15.82-13.26); 
 g2->SetPointError(8, 0,0, 13.26-9.64, 19.02-13.26); 
 // Summary: 250 16.32 17.78 24.50 20.67 15.14 13.00 
 g->SetPoint(9, 250,  16.32); 
 g0->SetPoint(9, 250, 17.78); g1->SetPoint(9, 250, 17.78);g2->SetPoint(9, 250, 17.78);
 g1->SetPointError(9, 0,0, 17.78-15.14, 20.67-17.78); 
 g2->SetPointError(9, 0,0, 17.78-13.00, 24.50-17.78); 
 // Summary: 300 20.96 22.75 31.50 26.71 19.76 17.67 
 g->SetPoint(10, 300,  20.96); 
 g0->SetPoint(10, 300, 22.75); g1->SetPoint(10, 300, 22.75);g2->SetPoint(10, 300, 22.75);
 g1->SetPointError(10, 0,0, 22.75-19.76, 26.71-22.75); 
 g2->SetPointError(10, 0,0, 22.75-17.67, 31.50-22.75); 
 // Summary: 350 27.94 28.97 39.39 33.82 25.10 22.19 
 g->SetPoint(11, 350,  27.94); 
 g0->SetPoint(11, 350, 28.97); g1->SetPoint(11, 350, 28.97);g2->SetPoint(11, 350, 28.97);
 g1->SetPointError(11, 0,0, 28.97-25.10, 33.82-28.97); 
 g2->SetPointError(11, 0,0, 28.97-22.19, 39.39-28.97); 
 // Summary: 400 34.38 34.76 47.83 40.83 30.17 26.77 
 g->SetPoint(12, 400,  34.38); 
 g0->SetPoint(12, 400, 34.76); g1->SetPoint(12, 400, 34.76);g2->SetPoint(12, 400, 34.76);
 g1->SetPointError(12, 0,0, 34.76-30.17, 40.83-34.76); 
 g2->SetPointError(12, 0,0, 34.76-26.77, 47.83-34.76); 
 // Summary: 450 44.33 43.79 60.00 51.25 38.18 33.75 
 g->SetPoint(13, 450,  44.33); 
 g0->SetPoint(13, 450, 43.79); g1->SetPoint(13, 450, 43.79);g2->SetPoint(13, 450, 43.79);
 g1->SetPointError(13, 0,0, 43.79-38.18, 51.25-43.79); 
 g2->SetPointError(13, 0,0, 43.79-33.75, 60.00-43.79); 
 // Summary: 500 56.84 54.17 73.57 63.61 47.08 41.54 
 g->SetPoint(14, 500,  56.84); 
 g0->SetPoint(14, 500, 54.17); g1->SetPoint(14, 500, 54.17);g2->SetPoint(14, 500, 54.17);
 g1->SetPointError(14, 0,0, 54.17-47.08, 63.61-54.17); 
 g2->SetPointError(14, 0,0, 54.17-41.54, 73.57-54.17); 
/*
Output for sample comb,all and mass 90
  5      4.78   5.11  10.29   7.26   3.68   2.74 
  8      3.63   3.44   7.25   5.01   2.48   1.85 
 10      2.81   2.44   5.25   3.59   1.76   1.31 
 13      1.78   1.53   3.35   2.27   1.10   0.82 
 16      1.27   1.03   2.26   1.53   0.74   0.55 
 20      0.80   0.66   1.46   0.98   0.48   0.36 
 23      0.59   0.50   1.10   0.74   0.36   0.27 
 26      0.46   0.39   0.86   0.58   0.28   0.21 
Limits: 18.30  16.32  24.25  19.85  13.83  11.90  comb all 90
 Output for sample comb,all and mass 100
  5      4.54   4.66   9.20   6.61   3.36   2.50 
  8      2.16   2.95   5.99   4.23   2.13   1.58 
 10      1.53   2.11   4.34   3.04   1.52   1.13 
 13      0.95   1.34   2.80   1.95   0.97   0.72 
 16      0.65   0.91   1.91   1.32   0.66   0.49 
 20      0.42   0.59   1.24   0.86   0.43   0.32 
 23      0.32   0.45   0.94   0.65   0.32   0.24 
 26      0.25   0.35   0.74   0.51   0.25   0.19 
Limits: 12.74  15.37  22.40  18.78  12.84  10.95  comb all 100
 Output for sample comb,all and mass 110
  5      3.56   4.18   8.29   5.94   3.01   2.24 
  8      2.07   2.79   5.62   3.99   2.01   1.50 
 10      1.16   1.63   3.37   2.35   1.18   0.88 
 13      0.74   1.06   2.21   1.54   0.76   0.57 
 16      0.51   0.73   1.54   1.07   0.53   0.39 
 20      0.33   0.49   1.03   0.71   0.35   0.26 
 23      0.26   0.37   0.79   0.54   0.27   0.20 
 26      0.20   0.29   0.62   0.43   0.21   0.16 
Limits: 11.14  13.55  20.38  16.78  11.29   9.61  comb all 110
 Output for sample comb,all and mass 120
  5      3.10   3.29   6.53   4.68   2.37   1.77 
  8      1.72   1.82   3.65   2.60   1.31   0.98 
 10      1.21   1.32   2.65   1.88   0.95   0.71 
 13      0.71   0.79   1.62   1.14   0.57   0.43 
 16      0.49   0.55   1.13   0.79   0.39   0.29 
 20      0.32   0.36   0.75   0.52   0.26   0.19 
Limits: 11.26  11.81  17.37  14.20   9.72   7.92  comb all 120
 Output for sample comb,all and mass 130
  5      2.88   2.93   5.76   4.15   2.11   1.57 
  8      1.61   1.64   3.26   2.33   1.18   0.88 
 10      1.15   1.17   2.34   1.66   0.84   0.63 
 13      0.74   0.75   1.51   1.07   0.54   0.40 
 16      0.51   0.52   1.04   0.74   0.37   0.28 
 20      0.33   0.34   0.68   0.48   0.24   0.18 
Limits: 11.10  11.21  16.44  13.64   9.06   7.48  comb all 130
 Output for sample comb,all and mass 140
  5      3.74   2.97   5.83   4.20   2.14   1.59 
  8      1.91   1.48   2.92   2.09   1.06   0.79 
 10      1.35   1.04   2.06   1.47   0.75   0.56 
 13      0.86   0.66   1.33   0.94   0.48   0.36 
 16      0.60   0.46   0.91   0.65   0.33   0.24 
 20      0.40   0.30   0.61   0.43   0.22   0.16 
Limits: 12.14  10.32  15.36  12.66   8.39   7.21  comb all 140
 Output for sample comb,all and mass 150
  5      3.12   3.07   6.03   4.34   2.21   1.65 
  8      2.15   1.73   3.44   2.46   1.25   0.93 
 10      1.35   1.08   2.15   1.54   0.78   0.58 
 13      0.88   0.69   1.38   0.98   0.50   0.37 
 16      0.61   0.47   0.95   0.67   0.34   0.25 
 20      0.40   0.31   0.62   0.44   0.22   0.17 
Limits: 12.23  10.62  15.65  12.89   9.06   7.71  comb all 150
 Output for sample comb,all and mass 170
  5      3.63   4.42   8.72   6.26   3.18   2.37 
  8      1.50   1.72   3.43   2.45   1.24   0.92 
 10      1.04   1.19   2.38   1.69   0.86   0.64 
 13      0.65   0.74   1.48   1.05   0.53   0.40 
 16      0.43   0.50   1.00   0.71   0.36   0.27 
 20      0.28   0.32   0.65   0.46   0.23   0.17 
Limits: 10.31  11.27  16.00  13.44   9.26   7.83  comb all 170
 Output for sample comb,all and mass 200
  5      4.51   6.21  12.24   8.81   4.47   3.33 
  8      2.00   2.54   5.02   3.59   1.83   1.36 
 10      1.35   1.70   3.42   2.43   1.23   0.92 
 13      0.83   1.03   2.07   1.47   0.74   0.55 
 16      0.55   0.68   1.37   0.97   0.49   0.37 
 20      0.35   0.43   0.88   0.62   0.31   0.23 
Limits: 12.02  13.26  19.02  15.82  11.41   9.64  comb all 200
 Output for sample comb,all and mass 250
 10      2.64   3.19   6.35   4.51   2.30   1.71 
 13      1.58   1.87   3.77   2.65   1.35   1.00 
 16      1.03   1.20   2.43   1.70   0.86   0.64 
 20      0.65   0.75   1.51   1.06   0.54   0.40 
 23      0.49   0.56   1.13   0.79   0.40   0.30 
 26      0.38   0.43   0.87   0.61   0.31   0.23 
 30      0.28   0.32   0.65   0.46   0.23   0.17 
Limits: 16.32  17.78  24.50  20.67  15.14  13.00  comb all 250
 Output for sample comb,all and mass 300
 13      2.87   3.61   7.19   5.08   2.60   1.94 
 16      1.83   2.24   4.54   3.16   1.62   1.20 
 20      1.09   1.33   2.71   1.89   0.96   0.72 
 23      0.81   0.97   1.97   1.38   0.70   0.52 
 26      0.62   0.74   1.50   1.05   0.53   0.40 
 30      0.46   0.54   1.09   0.77   0.39   0.29 
 35      0.33   0.39   0.79   0.55   0.28   0.21 
Limits: 20.96  22.75  31.50  26.71  19.76  17.67  comb all 300
 Output for sample comb,all and mass 350
 20      2.11   2.37   4.78   3.37   1.70   1.27 
 23      1.53   1.68   3.41   2.41   1.21   0.90 
 26      1.16   1.26   2.56   1.80   0.91   0.68 
 30      0.83   0.91   1.84   1.29   0.65   0.49 
 35      0.59   0.63   1.29   0.91   0.46   0.34 
 40      0.44   0.47   0.96   0.68   0.34   0.25 
Limits: 27.94  28.97  39.39  33.82  25.10  22.19  comb all 350
 Output for sample comb,all and mass 400
 23      2.48   2.65   5.34   3.77   1.91   1.42 
 26      1.88   1.97   4.00   2.82   1.42   1.06 
 30      1.35   1.40   2.84   2.01   1.01   0.75 
 35      0.95   0.98   1.98   1.40   0.71   0.53 
 40      0.70   0.72   1.47   1.04   0.52   0.39 
 45      0.54   0.55   1.13   0.80   0.40   0.30 
 50      0.43   0.44   0.90   0.63   0.32   0.24 
 55      0.35   0.36   0.73   0.51   0.26   0.19 
Limits: 34.38  34.76  47.83  40.83  30.17  26.77  comb all 400
 Output for sample comb,all and mass 450
 30      2.44   2.42   4.92   3.48   1.74   1.30 
 35      1.71   1.67   3.40   2.40   1.21   0.90 
 40      1.26   1.22   2.48   1.76   0.88   0.66 
 45      0.96   0.93   1.89   1.33   0.67   0.50 
 50      0.76   0.73   1.50   1.05   0.53   0.39 
 55      0.61   0.59   1.21   0.85   0.43   0.32 
 60      0.51   0.49   1.00   0.70   0.35   0.26 
 65      0.43   0.41   0.84   0.59   0.29   0.22 
 70      0.36   0.35   0.71   0.50   0.25   0.19 
Limits: 44.33  43.79  60.00  51.25  38.18  33.75  comb all 450
 Output for sample comb,all and mass 500
 40      2.21   2.01   4.09   2.89   1.45   1.08 
 45      1.68   1.53   3.13   2.20   1.10   0.82 
 50      1.33   1.20   2.44   1.72   0.86   0.64 
 55      1.07   0.96   1.98   1.38   0.70   0.52 
 60      0.88   0.79   1.62   1.13   0.57   0.43 
 65      0.74   0.66   1.36   0.95   0.48   0.36 
 70      0.63   0.56   1.15   0.80   0.40   0.30 
eP2Limit extrapolation is done to 73.571428571
Limits: 56.84  54.17  73.57  63.61  47.08  41.54  comb all 500
 --
Limits: 18.30  16.32  24.25  19.85  13.83  11.90  comb all 90
Limits: 12.74  15.37  22.40  18.78  12.84  10.95  comb all 100
Limits: 11.14  13.55  20.38  16.78  11.29   9.61  comb all 110
Limits: 11.26  11.81  17.37  14.20   9.72   7.92  comb all 120
Limits: 11.10  11.21  16.44  13.64   9.06   7.48  comb all 130
Limits: 12.14  10.32  15.36  12.66   8.39   7.21  comb all 140
Limits: 12.23  10.62  15.65  12.89   9.06   7.71  comb all 150
Limits: 10.31  11.27  16.00  13.44   9.26   7.83  comb all 170
Limits: 12.02  13.26  19.02  15.82  11.41   9.64  comb all 200
Limits: 16.32  17.78  24.50  20.67  15.14  13.00  comb all 250
Limits: 20.96  22.75  31.50  26.71  19.76  17.67  comb all 300
Limits: 27.94  28.97  39.39  33.82  25.10  22.19  comb all 350
Limits: 34.38  34.76  47.83  40.83  30.17  26.77  comb all 400
Limits: 44.33  43.79  60.00  51.25  38.18  33.75  comb all 450
Limits: 56.84  54.17  73.57  63.61  47.08  41.54  comb all 500
*/
// Warning: results may be extrapolated


   // old limit
   TGraphAsymmErrors *gV1  = new TGraphAsymmErrors(); // data observed
   TGraphAsymmErrors *g0V1 = new TGraphAsymmErrors(); // data expected
   TGraphAsymmErrors *g1V1 = new TGraphAsymmErrors(); // data expected: 1 sigma
   TGraphAsymmErrors *g2V1 = new TGraphAsymmErrors(); // data expected: 2 sigma

 // Summary: 90 21.50 16.53 24.68 20.12 14.15 12.25 
 gV1->SetPoint(0, 90,  21.50); 
 g0V1->SetPoint(0, 90, 16.53); g1V1->SetPoint(0, 90, 16.53);g2V1->SetPoint(0, 90, 16.53);
 g1V1->SetPointError(0, 0,0, 16.53-14.15, 20.12-16.53); 
 g2V1->SetPointError(0, 0,0, 16.53-12.25, 24.68-16.53); 
 // Summary: 100 17.43 16.00 23.65 19.62 13.67 11.80 
 gV1->SetPoint(1, 100,  17.43); 
 g0V1->SetPoint(1, 100, 16.00); g1V1->SetPoint(1, 100, 16.00);g2V1->SetPoint(1, 100, 16.00);
 g1V1->SetPointError(1, 0,0, 16.00-13.67, 19.62-16.00); 
 g2V1->SetPointError(1, 0,0, 16.00-11.80, 23.65-16.00); 
 // Summary: 110 14.08 14.54 21.67 17.86 12.14 10.08 
 gV1->SetPoint(2, 110,  14.08); 
 g0V1->SetPoint(2, 110, 14.54); g1V1->SetPoint(2, 110, 14.54);g2V1->SetPoint(2, 110, 14.54);
 g1V1->SetPointError(2, 0,0, 14.54-12.14, 17.86-14.54); 
 g2V1->SetPointError(2, 0,0, 14.54-10.08, 21.67-14.54); 
 // Summary: 120 14.05 12.42 18.60 15.18 10.37 8.58 
 gV1->SetPoint(3, 120,  14.05); 
 g0V1->SetPoint(3, 120, 12.42); g1V1->SetPoint(3, 120, 12.42);g2V1->SetPoint(3, 120, 12.42);
 g1V1->SetPointError(3, 0,0, 12.42-10.37, 15.18-12.42); 
 g2V1->SetPointError(3, 0,0, 12.42-8.58, 18.60-12.42); 
 // Summary: 130 13.19 11.74 17.54 14.42 9.50 7.89 
 gV1->SetPoint(4, 130,  13.19); 
 g0V1->SetPoint(4, 130, 11.74); g1V1->SetPoint(4, 130, 11.74);g2V1->SetPoint(4, 130, 11.74);
 g1V1->SetPointError(4, 0,0, 11.74-9.50, 14.42-11.74); 
 g2V1->SetPointError(4, 0,0, 11.74-7.89, 17.54-11.74); 
 // Summary: 140 13.92 11.02 16.22 13.36 9.00 7.60 
 gV1->SetPoint(5, 140,  13.92); 
 g0V1->SetPoint(5, 140, 11.02); g1V1->SetPoint(5, 140, 11.02);g2V1->SetPoint(5, 140, 11.02);
 g1V1->SetPointError(5, 0,0, 11.02-9.00, 13.36-11.02); 
 g2V1->SetPointError(5, 0,0, 11.02-7.60, 16.22-11.02); 
 // Summary: 150 13.28 11.36 16.56 13.77 9.50 8.16 
 gV1->SetPoint(6, 150,  13.28); 
 g0V1->SetPoint(6, 150, 11.36); g1V1->SetPoint(6, 150, 11.36);g2V1->SetPoint(6, 150, 11.36);
 g1V1->SetPointError(6, 0,0, 11.36-9.50, 13.77-11.36); 
 g2V1->SetPointError(6, 0,0, 11.36-8.16, 16.56-11.36); 
 // Summary: 170 11.13 11.92 17.30 14.38 9.77 8.19 
 gV1->SetPoint(7, 170,  11.13); 
 g0V1->SetPoint(7, 170, 11.92); g1V1->SetPoint(7, 170, 11.92);g2V1->SetPoint(7, 170, 11.92);
 g1V1->SetPointError(7, 0,0, 11.92-9.77, 14.38-11.92); 
 g2V1->SetPointError(7, 0,0, 11.92-8.19, 17.30-11.92); 
 // Summary: 200 11.98 14.71 20.81 17.71 12.43 10.64 
 gV1->SetPoint(8, 200,  11.98); 
 g0V1->SetPoint(8, 200, 14.71); g1V1->SetPoint(8, 200, 14.71);g2V1->SetPoint(8, 200, 14.71);
 g1V1->SetPointError(8, 0,0, 14.71-12.43, 17.71-14.71); 
 g2V1->SetPointError(8, 0,0, 14.71-10.64, 20.81-14.71); 
 // Summary: 250 18.45 20.89 29.39 24.85 18.13 15.59 
 gV1->SetPoint(9, 250,  18.45); 
 g0V1->SetPoint(9, 250, 20.89); g1V1->SetPoint(9, 250, 20.89);g2V1->SetPoint(9, 250, 20.89);
 g1V1->SetPointError(9, 0,0, 20.89-18.13, 24.85-20.89); 
 g2V1->SetPointError(9, 0,0, 20.89-15.59, 29.39-20.89); 
 // Summary: 300 24.04 26.14 36.48 30.86 22.53 19.71 
 gV1->SetPoint(10, 300,  24.04); 
 g0V1->SetPoint(10, 300, 26.14); g1V1->SetPoint(10, 300, 26.14);g2V1->SetPoint(10, 300, 26.14);
 g1V1->SetPointError(10, 0,0, 26.14-22.53, 30.86-26.14); 
 g2V1->SetPointError(10, 0,0, 26.14-19.71, 36.48-26.14); 
 // Summary: 350 31.82 33.38 45.71 39.06 28.92 25.45 
 gV1->SetPoint(11, 350,  31.82); 
 g0V1->SetPoint(11, 350, 33.38); g1V1->SetPoint(11, 350, 33.38);g2V1->SetPoint(11, 350, 33.38);
 g1V1->SetPointError(11, 0,0, 33.38-28.92, 39.06-33.38); 
 g2V1->SetPointError(11, 0,0, 33.38-25.45, 45.71-33.38); 
 // Summary: 400 39.57 40.83 56.39 48.04 35.37 31.36 
 gV1->SetPoint(12, 400,  39.57); 
 g0V1->SetPoint(12, 400, 40.83); g1V1->SetPoint(12, 400, 40.83);g2V1->SetPoint(12, 400, 40.83);
 g1V1->SetPointError(12, 0,0, 40.83-35.37, 48.04-40.83); 
 g2V1->SetPointError(12, 0,0, 40.83-31.36, 56.39-40.83); 
 // Summary: 450 51.90 50.75 70.00 59.76 44.17 39.00 
 gV1->SetPoint(13, 450,  51.90); 
 g0V1->SetPoint(13, 450, 50.75); g1V1->SetPoint(13, 450, 50.75);g2V1->SetPoint(13, 450, 50.75);
 g1V1->SetPointError(13, 0,0, 50.75-44.17, 59.76-50.75); 
 g2V1->SetPointError(13, 0,0, 50.75-39.00, 70.00-50.75); 
 // Summary: 500 67.65 62.22 80.36 72.50 53.91 47.60 
 gV1->SetPoint(14, 500,  67.65); 
 g0V1->SetPoint(14, 500, 62.22); g1V1->SetPoint(14, 500, 62.22);g2V1->SetPoint(14, 500, 62.22);
 g1V1->SetPointError(14, 0,0, 62.22-53.91, 72.50-62.22); 
 g2V1->SetPointError(14, 0,0, 62.22-47.60, 80.36-62.22); 
/*
Output for sample comb,all and mass 90
  5      8.46   6.59  13.48   9.33   4.75   3.54 
  8      6.22   3.98   8.97   5.97   2.87   2.14 
 10      4.25   2.65   6.10   4.01   1.91   1.42 
 13      2.71   1.60   3.64   2.40   1.15   0.86 
 16      1.85   1.05   2.39   1.58   0.76   0.57 
 20      1.18   0.67   1.52   1.01   0.48   0.36 
 23      0.82   0.51   1.14   0.76   0.36   0.27 
 26      0.69   0.40   0.89   0.59   0.29   0.21 
Limits: 21.50  16.53  24.68  20.12  14.15  12.25  comb all 90
 Output for sample comb,all and mass 100
  5      7.78   5.45  11.03   7.79   3.93   2.92 
  8      4.01   3.48   7.24   4.90   2.50   1.87 
 10      2.83   2.42   5.14   3.53   1.74   1.30 
 13      1.75   1.50   3.22   2.20   1.08   0.80 
 16      1.15   1.00   2.16   1.47   0.72   0.54 
 20      0.73   0.64   1.37   0.95   0.46   0.34 
 23      0.57   0.49   1.05   0.71   0.35   0.26 
 26      0.44   0.38   0.82   0.56   0.27   0.20 
Limits: 17.43  16.00  23.65  19.62  13.67  11.80  comb all 100
 Output for sample comb,all and mass 110
  5      5.80   4.98  10.09   7.12   3.59   2.67 
  8      3.44   3.29   6.75   4.75   2.37   1.77 
 10      1.76   1.88   3.96   2.66   1.35   1.01 
 13      1.14   1.19   2.53   1.74   0.86   0.64 
 16      0.75   0.82   1.74   1.20   0.59   0.44 
 20      0.49   0.54   1.15   0.77   0.39   0.29 
 23      0.37   0.41   0.88   0.60   0.29   0.22 
 26      0.31   0.32   0.69   0.47   0.23   0.17 
Limits: 14.08  14.54  21.67  17.86  12.14  10.08  comb all 110
 Output for sample comb,all and mass 120
  5      4.53   3.72   7.50   5.10   2.68   2.00 
  8      2.65   2.03   4.14   2.92   1.46   1.09 
 10      1.89   1.46   2.98   2.10   1.05   0.78 
 13      1.13   0.89   1.85   1.29   0.64   0.48 
 16      0.76   0.61   1.28   0.89   0.44   0.33 
 20      0.52   0.40   0.85   0.58   0.29   0.22 
Limits: 14.05  12.42  18.60  15.18  10.37   8.58  comb all 120
 Output for sample comb,all and mass 130
  5      3.45   3.31   6.63   4.69   2.38   1.77 
  8      2.23   1.81   3.67   2.58   1.30   0.97 
 10      1.59   1.25   2.60   1.82   0.90   0.67 
 13      1.02   0.82   1.67   1.17   0.59   0.44 
 16      0.71   0.56   1.15   0.81   0.40   0.30 
 20      0.44   0.37   0.76   0.52   0.26   0.20 
Limits: 13.19  11.74  17.54  14.42   9.50   7.89  comb all 130
 Output for sample comb,all and mass 140
  5      4.42   3.32   6.63   4.72   2.39   1.78 
  8      2.33   1.64   3.28   2.33   1.18   0.88 
 10      1.64   1.14   2.30   1.63   0.82   0.61 
 13      1.11   0.73   1.48   1.04   0.52   0.39 
 16      0.75   0.50   1.02   0.71   0.36   0.27 
 20      0.50   0.33   0.66   0.47   0.24   0.18 
Limits: 13.92  11.02  16.22  13.36   9.00   7.60  comb all 140
 Output for sample comb,all and mass 150
  5      3.62   3.53   7.04   4.76   2.54   1.89 
  8      2.57   1.92   3.86   2.75   1.39   1.03 
 10      1.61   1.20   2.42   1.71   0.87   0.65 
 13      1.03   0.76   1.54   1.09   0.55   0.41 
 16      0.71   0.52   1.05   0.74   0.37   0.28 
 20      0.47   0.34   0.69   0.48   0.24   0.18 
Limits: 13.28  11.36  16.56  13.77   9.50   8.16  comb all 150
 Output for sample comb,all and mass 170
  5      4.31   5.02  10.06   7.14   3.61   2.69 
  8      1.71   1.93   3.87   2.74   1.39   1.03 
 10      1.17   1.32   2.67   1.89   0.95   0.71 
 13      0.72   0.82   1.67   1.18   0.59   0.44 
 16      0.48   0.55   1.13   0.79   0.40   0.30 
 20      0.31   0.36   0.73   0.51   0.26   0.19 
Limits: 11.13  11.92  17.30  14.38   9.77   8.19  comb all 170
 Output for sample comb,all and mass 200
  5      5.27   7.61  15.22  10.86   5.48   4.08 
  8      2.06   3.00   5.99   4.26   2.16   1.61 
 10      1.37   2.04   4.07   2.89   1.47   1.09 
 13      0.81   1.24   2.49   1.76   0.89   0.67 
 16      0.54   0.82   1.66   1.18   0.59   0.44 
 20      0.32   0.53   1.07   0.76   0.38   0.28 
 23      0.26   0.40   0.81   0.57   0.29   0.22 
 26      0.20   0.31   0.63   0.45   0.23   0.17 
Limits: 11.98  14.71  20.81  17.71  12.43  10.64  comb all 200
 Output for sample comb,all and mass 250
 10      3.44   4.53   9.05   6.44   3.26   2.43 
 13      2.03   2.69   5.44   3.83   1.94   1.44 
 16      1.30   1.74   3.52   2.48   1.25   0.93 
 20      0.81   1.08   2.20   1.55   0.78   0.58 
 23      0.61   0.81   1.64   1.16   0.58   0.43 
 26      0.48   0.63   1.28   0.90   0.45   0.34 
 30      0.35   0.47   0.95   0.67   0.34   0.25 
Limits: 18.45  20.89  29.39  24.85  18.13  15.59  comb all 250
 Output for sample comb,all and mass 300
 13      4.03   4.96   9.89   7.08   3.57   2.66 
 16      2.52   3.07   6.25   4.41   2.21   1.65 
 20      1.49   1.77   3.71   2.61   1.27   0.95 
 23      1.09   1.32   2.70   1.86   0.95   0.71 
 26      0.83   1.01   2.05   1.44   0.72   0.54 
 30      0.60   0.73   1.50   1.05   0.53   0.39 
 35      0.44   0.53   1.08   0.76   0.38   0.28 
 40      0.33   0.40   0.81   0.57   0.29   0.21 
Limits: 24.04  26.14  36.48  30.86  22.53  19.71  comb all 300
 Output for sample comb,all and mass 350
 20      2.92   3.33   6.76   4.76   2.40   1.79 
 23      2.10   2.36   4.82   3.39   1.70   1.27 
 26      1.56   1.76   3.60   2.52   1.27   0.94 
 30      1.12   1.25   2.57   1.80   0.90   0.67 
 35      0.79   0.88   1.80   1.26   0.63   0.47 
 40      0.59   0.66   1.34   0.94   0.47   0.35 
 45      0.45   0.51   1.03   0.72   0.36   0.27 
 50      0.36   0.40   0.82   0.58   0.29   0.22 
 60      0.25   0.27   0.56   0.39   0.20   0.15 
Limits: 31.82  33.38  45.71  39.06  28.92  25.45  comb all 350
 Output for sample comb,all and mass 400
 23      3.52   3.87   7.83   5.52   2.79   2.08 
 26      2.63   2.87   5.84   4.03   2.07   1.54 
 30      1.88   2.03   4.15   2.91   1.46   1.09 
 35      1.32   1.41   2.89   2.02   1.02   0.76 
 40      0.97   1.04   2.13   1.49   0.75   0.56 
 45      0.75   0.80   1.63   1.14   0.57   0.43 
 50      0.59   0.63   1.29   0.91   0.46   0.34 
 55      0.48   0.51   1.05   0.74   0.37   0.28 
 60      0.40   0.42   0.87   0.61   0.31   0.23 
Limits: 39.57  40.83  56.39  48.04  35.37  31.36  comb all 400
 Output for sample comb,all and mass 450
 30      3.57   3.49   7.10   4.98   2.51   1.87 
 35      2.53   2.39   4.88   3.43   1.72   1.28 
 40      1.80   1.74   3.55   2.49   1.25   0.93 
 45      1.37   1.32   2.71   1.85   0.95   0.71 
 50      1.08   1.03   2.12   1.48   0.74   0.55 
 55      0.87   0.83   1.71   1.20   0.60   0.45 
 60      0.72   0.69   1.41   0.99   0.50   0.37 
 65      0.60   0.57   1.18   0.83   0.41   0.31 
 70      0.51   0.49   1.00   0.70   0.35   0.26 
Limits: 51.90  50.75  70.00  59.76  44.17  39.00  comb all 450
 Output for sample comb,all and mass 500
 40      3.31   2.78   5.72   4.00   2.01   1.49 
 45      2.57   2.10   4.33   3.02   1.52   1.13 
 50      1.96   1.64   3.39   2.36   1.18   0.88 
 55      1.58   1.32   2.72   1.90   0.95   0.71 
 60      1.30   1.08   2.23   1.55   0.78   0.58 
 65      1.09   0.90   1.86   1.30   0.65   0.48 
 70      0.92   0.76   1.58   1.10   0.55   0.41 
eP2Limit extrapolation is done to 80.357142857
eP1Limit extrapolation is done to 72.500000000
Limits: 67.65  62.22  80.36  72.50  53.91  47.60  comb all 500
 --
Limits: 21.50  16.53  24.68  20.12  14.15  12.25  comb all 90
Limits: 17.43  16.00  23.65  19.62  13.67  11.80  comb all 100
Limits: 14.08  14.54  21.67  17.86  12.14  10.08  comb all 110
Limits: 14.05  12.42  18.60  15.18  10.37   8.58  comb all 120
Limits: 13.19  11.74  17.54  14.42   9.50   7.89  comb all 130
Limits: 13.92  11.02  16.22  13.36   9.00   7.60  comb all 140
Limits: 13.28  11.36  16.56  13.77   9.50   8.16  comb all 150
Limits: 11.13  11.92  17.30  14.38   9.77   8.19  comb all 170
Limits: 11.98  14.71  20.81  17.71  12.43  10.64  comb all 200
Limits: 18.45  20.89  29.39  24.85  18.13  15.59  comb all 250
Limits: 24.04  26.14  36.48  30.86  22.53  19.71  comb all 300
Limits: 31.82  33.38  45.71  39.06  28.92  25.45  comb all 350
Limits: 39.57  40.83  56.39  48.04  35.37  31.36  comb all 400
Limits: 51.90  50.75  70.00  59.76  44.17  39.00  comb all 450
Limits: 67.65  62.22  80.36  72.50  53.91  47.60  comb all 500
*/
// Warning: results may be extrapolated


   // Stats only
   TGraphAsymmErrors *gV2  = new TGraphAsymmErrors(); // data observed
   TGraphAsymmErrors *g0V2 = new TGraphAsymmErrors(); // data expected
   TGraphAsymmErrors *g1V2 = new TGraphAsymmErrors(); // data expected: 1 sigma
   TGraphAsymmErrors *g2V2 = new TGraphAsymmErrors(); // data expected: 2 sigma

 // Summary: 90 4.06 8.95 12.64 10.84 7.40 6.02 
 gV2->SetPoint(0, 90,  4.06); 
 g0V2->SetPoint(0, 90, 8.95); g1V2->SetPoint(0, 90, 8.95);g2V2->SetPoint(0, 90, 8.95);
 g1V2->SetPointError(0, 0,0, 8.95-7.40, 10.84-8.95); 
 g2V2->SetPointError(0, 0,0, 8.95-6.02, 12.64-8.95); 
 // Summary: 100 4.16 6.73 9.24 7.81 5.26 3.43 
 gV2->SetPoint(1, 100,  4.16); 
 g0V2->SetPoint(1, 100, 6.73); g1V2->SetPoint(1, 100, 6.73);g2V2->SetPoint(1, 100, 6.73);
 g1V2->SetPointError(1, 0,0, 6.73-5.26, 7.81-6.73); 
 g2V2->SetPointError(1, 0,0, 6.73-3.43, 9.24-6.73); 
 // Summary: 110 3.11 7.08 9.74 8.41 5.46 3.42 
 gV2->SetPoint(2, 110,  3.11); 
 g0V2->SetPoint(2, 110, 7.08); g1V2->SetPoint(2, 110, 7.08);g2V2->SetPoint(2, 110, 7.08);
 g1V2->SetPointError(2, 0,0, 7.08-5.46, 8.41-7.08); 
 g2V2->SetPointError(2, 0,0, 7.08-3.42, 9.74-7.08); 
 // Summary: 120 2.91 7.08 10.15 8.55 5.46 3.42 
 gV2->SetPoint(3, 120,  2.91); 
 g0V2->SetPoint(3, 120, 7.08); g1V2->SetPoint(3, 120, 7.08);g2V2->SetPoint(3, 120, 7.08);
 g1V2->SetPointError(3, 0,0, 7.08-5.46, 8.55-7.08); 
 g2V2->SetPointError(3, 0,0, 7.08-3.42, 10.15-7.08); 
 // Summary: 130 2.66 7.25 10.62 8.86 5.63 3.69 
 gV2->SetPoint(4, 130,  2.66); 
 g0V2->SetPoint(4, 130, 7.25); g1V2->SetPoint(4, 130, 7.25);g2V2->SetPoint(4, 130, 7.25);
 g1V2->SetPointError(4, 0,0, 7.25-5.63, 8.86-7.25); 
 g2V2->SetPointError(4, 0,0, 7.25-3.69, 10.62-7.25); 
 // Summary: 140 1.60 7.55 11.10 9.19 6.21 4.54 
 gV2->SetPoint(5, 140,  1.60); 
 g0V2->SetPoint(5, 140, 7.55); g1V2->SetPoint(5, 140, 7.55);g2V2->SetPoint(5, 140, 7.55);
 g1V2->SetPointError(5, 0,0, 7.55-6.21, 9.19-7.55); 
 g2V2->SetPointError(5, 0,0, 7.55-4.54, 11.10-7.55); 
 // Summary: 150 1.08 8.00 11.50 9.62 6.47 4.63 
 gV2->SetPoint(6, 150,  1.08); 
 g0V2->SetPoint(6, 150, 8.00); g1V2->SetPoint(6, 150, 8.00);g2V2->SetPoint(6, 150, 8.00);
 g1V2->SetPointError(6, 0,0, 8.00-6.47, 9.62-8.00); 
 g2V2->SetPointError(6, 0,0, 8.00-4.63, 11.50-8.00); 
 // Summary: 170 2.62 8.55 12.43 10.46 7.33 6.30 
 gV2->SetPoint(7, 170,  2.62); 
 g0V2->SetPoint(7, 170, 8.55); g1V2->SetPoint(7, 170, 8.55);g2V2->SetPoint(7, 170, 8.55);
 g1V2->SetPointError(7, 0,0, 8.55-7.33, 10.46-8.55); 
 g2V2->SetPointError(7, 0,0, 8.55-6.30, 12.43-8.55); 
 // Summary: 200 4.19 10.45 14.76 12.57 8.61 7.39 
 gV2->SetPoint(8, 200,  4.19); 
 g0V2->SetPoint(8, 200, 10.45); g1V2->SetPoint(8, 200, 10.45);g2V2->SetPoint(8, 200, 10.45);
 g1V2->SetPointError(8, 0,0, 10.45-8.61, 12.57-10.45); 
 g2V2->SetPointError(8, 0,0, 10.45-7.39, 14.76-10.45); 
 // Summary: 250 10.56 14.93 20.12 17.67 12.49 10.54 
 gV2->SetPoint(9, 250,  10.56); 
 g0V2->SetPoint(9, 250, 14.93); g1V2->SetPoint(9, 250, 14.93);g2V2->SetPoint(9, 250, 14.93);
 g1V2->SetPointError(9, 0,0, 14.93-12.49, 17.67-14.93); 
 g2V2->SetPointError(9, 0,0, 14.93-10.54, 20.12-14.93); 
 // Summary: 300 15.16 19.79 26.59 23.00 17.14 14.76 
 gV2->SetPoint(10, 300,  15.16); 
 g0V2->SetPoint(10, 300, 19.79); g1V2->SetPoint(10, 300, 19.79);g2V2->SetPoint(10, 300, 19.79);
 g1V2->SetPointError(10, 0,0, 19.79-17.14, 23.00-19.79); 
 g2V2->SetPointError(10, 0,0, 19.79-14.76, 26.59-19.79); 
 // Summary: 350 21.11 25.70 34.21 29.78 22.25 19.36 
 gV2->SetPoint(11, 350,  21.11); 
 g0V2->SetPoint(11, 350, 25.70); g1V2->SetPoint(11, 350, 25.70);g2V2->SetPoint(11, 350, 25.70);
 g1V2->SetPointError(11, 0,0, 25.70-22.25, 29.78-25.70); 
 g2V2->SetPointError(11, 0,0, 25.70-19.36, 34.21-25.70); 
 // Summary: 400 26.76 31.88 42.20 36.96 27.38 23.84 
 gV2->SetPoint(12, 400,  26.76); 
 g0V2->SetPoint(12, 400, 31.88); g1V2->SetPoint(12, 400, 31.88);g2V2->SetPoint(12, 400, 31.88);
 g1V2->SetPointError(12, 0,0, 31.88-27.38, 36.96-31.88); 
 g2V2->SetPointError(12, 0,0, 31.88-23.84, 42.20-31.88); 
 // Summary: 450 35.75 40.00 53.33 46.59 34.62 30.17 
 gV2->SetPoint(13, 450,  35.75); 
 g0V2->SetPoint(13, 450, 40.00); g1V2->SetPoint(13, 450, 40.00);g2V2->SetPoint(13, 450, 40.00);
 g1V2->SetPointError(13, 0,0, 40.00-34.62, 46.59-40.00); 
 g2V2->SetPointError(13, 0,0, 40.00-30.17, 53.33-40.00); 
 // Summary: 500 46.47 50.00 66.56 58.16 43.27 37.68 
 gV2->SetPoint(14, 500,  46.47); 
 g0V2->SetPoint(14, 500, 50.00); g1V2->SetPoint(14, 500, 50.00);g2V2->SetPoint(14, 500, 50.00);
 g1V2->SetPointError(14, 0,0, 50.00-43.27, 58.16-50.00); 
 g2V2->SetPointError(14, 0,0, 50.00-37.68, 66.56-50.00); 
/*
Output for sample comb,all and mass 90
  5      0.89   2.23   4.29   3.13   1.60   1.19 
obsLimit back-extrapolation is done to 4.057142858
  8      0.54   1.18   2.25   1.65   0.85   0.63 
 10      0.39   0.80   1.52   1.12   0.57   0.43 
 13      0.25   0.49   0.93   0.69   0.35   0.26 
 16      0.17   0.33   0.63   0.46   0.24   0.18 
 20      0.12   0.21   0.41   0.30   0.15   0.11 
Limits:  4.06   8.95  12.64  10.84   7.40   6.02  comb all 90
 Output for sample comb,all and mass 100
  5      0.86   1.45   2.73   2.02   1.05   0.78 
obsLimit back-extrapolation is done to 4.160000000
eM2Limit back-extrapolation is done to 3.428571429
  8      0.36   0.67   1.26   0.93   0.48   0.36 
 10      0.25   0.45   0.84   0.63   0.32   0.24 
 13      0.16   0.28   0.52   0.38   0.20   0.15 
 16      0.11   0.18   0.35   0.26   0.13   0.10 
 20      0.07   0.12   0.22   0.17   0.09   0.06 
Limits:  4.16   6.73   9.24   7.81   5.26   3.43  comb all 100
 Output for sample comb,all and mass 110
  5      0.78   1.50   2.82   2.09   1.08   0.80 
obsLimit back-extrapolation is done to 3.114285715
eM2Limit back-extrapolation is done to 3.421052632
  8      0.43   0.78   1.46   1.08   0.56   0.42 
 10      0.26   0.50   0.93   0.69   0.36   0.27 
 13      0.16   0.31   0.58   0.43   0.22   0.17 
 16      0.11   0.21   0.39   0.29   0.15   0.11 
 20      0.07   0.14   0.25   0.19   0.10   0.07 
Limits:  3.11   7.08   9.74   8.41   5.46   3.42  comb all 110
 Output for sample comb,all and mass 120
  5      0.77   1.50   2.82   2.09   1.08   0.80 
obsLimit back-extrapolation is done to 2.909090910
eM2Limit back-extrapolation is done to 3.421052632
  8      0.44   0.78   1.47   1.09   0.56   0.42 
 10      0.31   0.55   1.02   0.76   0.39   0.29 
 13      0.19   0.33   0.62   0.46   0.24   0.18 
 16      0.13   0.22   0.42   0.31   0.16   0.12 
 20      0.08   0.15   0.28   0.20   0.11   0.08 
Limits:  2.91   7.08  10.15   8.55   5.46   3.42  comb all 120
 Output for sample comb,all and mass 130
  5      0.75   1.54   2.90   2.15   1.11   0.83 
obsLimit back-extrapolation is done to 2.656250000
eM2Limit back-extrapolation is done to 3.692307693
  8      0.43   0.82   1.55   1.15   0.59   0.44 
 10      0.31   0.58   1.08   0.80   0.42   0.31 
 13      0.20   0.37   0.69   0.51   0.26   0.20 
 16      0.14   0.25   0.47   0.35   0.18   0.13 
 20      0.09   0.16   0.31   0.23   0.12   0.09 
Limits:  2.66   7.25  10.62   8.86   5.63   3.69  comb all 130
 Output for sample comb,all and mass 140
  5      0.66   1.73   3.27   2.41   1.25   0.93 
obsLimit back-extrapolation is done to 1.600000000
eM2Limit back-extrapolation is done to 4.543478261
  8      0.36   0.87   1.64   1.22   0.63   0.47 
 10      0.26   0.61   1.15   0.85   0.44   0.33 
 13      0.17   0.39   0.74   0.55   0.28   0.21 
 16      0.12   0.27   0.51   0.38   0.19   0.14 
 20      0.08   0.18   0.33   0.25   0.13   0.10 
Limits:  1.60   7.55  11.10   9.19   6.21   4.54  comb all 140
 Output for sample comb,all and mass 150
  5      0.66   1.76   3.34   2.46   1.27   0.95 
obsLimit back-extrapolation is done to 1.076923077
eM2Limit back-extrapolation is done to 4.634146342
  8      0.40   1.00   1.87   1.39   0.72   0.54 
 10      0.28   0.65   1.22   0.91   0.47   0.35 
 13      0.19   0.42   0.78   0.58   0.30   0.22 
 16      0.13   0.29   0.54   0.40   0.21   0.15 
 20      0.09   0.19   0.35   0.26   0.14   0.10 
Limits:  1.08   8.00  11.50   9.62   6.47   4.63  comb all 150
 Output for sample comb,all and mass 170
  5      0.73   2.46   4.66   3.44   1.77   1.32 
obsLimit back-extrapolation is done to 2.617647059
  8      0.39   1.09   2.05   1.52   0.78   0.58 
 10      0.28   0.76   1.43   1.06   0.55   0.41 
 13      0.18   0.48   0.90   0.67   0.35   0.26 
 16      0.13   0.33   0.61   0.45   0.23   0.17 
 20      0.08   0.21   0.40   0.30   0.15   0.11 
Limits:  2.62   8.55  12.43  10.46   7.33   6.30  comb all 170
 Output for sample comb,all and mass 200
  5      0.90   3.18   6.05   4.44   2.29   1.70 
obsLimit back-extrapolation is done to 4.189189190
  8      0.53   1.52   2.87   2.12   1.10   0.82 
 10      0.39   1.06   1.99   1.48   0.77   0.57 
 13      0.26   0.66   1.24   0.92   0.48   0.35 
 16      0.18   0.44   0.83   0.62   0.32   0.24 
 20      0.12   0.29   0.54   0.40   0.21   0.15 
Limits:  4.19  10.45  14.76  12.57   8.61   7.39  comb all 200
 Output for sample comb,all and mass 250
 10      1.05   2.00   3.76   2.79   1.44   1.07 
 13      0.78   1.27   2.37   1.76   0.91   0.68 
 16      0.58   0.85   1.58   1.18   0.61   0.45 
 20      0.40   0.54   1.01   0.75   0.39   0.29 
 23      0.31   0.41   0.76   0.57   0.29   0.22 
 26      0.25   0.32   0.59   0.44   0.23   0.17 
 30      0.19   0.24   0.44   0.33   0.17   0.13 
Limits: 10.56  14.93  20.12  17.67  12.49  10.54  comb all 250
 Output for sample comb,all and mass 300
 13      1.18   2.31   4.33   3.21   1.66   1.24 
 16      0.93   1.55   2.90   2.16   1.12   0.83 
 20      0.65   0.97   1.81   1.35   0.70   0.52 
 23      0.51   0.72   1.35   1.00   0.52   0.39 
 26      0.41   0.56   1.04   0.77   0.40   0.30 
 30      0.32   0.41   0.77   0.57   0.30   0.22 
 35      0.24   0.30   0.56   0.41   0.21   0.16 
Limits: 15.16  19.79  26.59  23.00  17.14  14.76  comb all 300
 Output for sample comb,all and mass 350
 13      1.56   3.52   6.70   4.92   2.53   1.89 
 16      1.38   2.64   4.96   3.68   1.90   1.42 
 20      1.07   1.72   3.21   2.39   1.24   0.92 
 23      0.88   1.27   2.38   1.77   0.92   0.68 
 26      0.71   0.97   1.81   1.35   0.70   0.52 
 30      0.55   0.71   1.32   0.98   0.51   0.38 
 35      0.41   0.50   0.94   0.70   0.36   0.27 
 40      0.32   0.38   0.71   0.52   0.27   0.20 
Limits: 21.11  25.70  34.21  29.78  22.25  19.36  comb all 350
 Output for sample comb,all and mass 400
 23      1.23   1.99   3.72   2.76   1.43   1.07 
 26      1.04   1.53   2.86   2.13   1.10   0.82 
 30      0.83   1.12   2.09   1.56   0.81   0.60 
 35      0.64   0.80   1.49   1.11   0.57   0.43 
 40      0.50   0.59   1.11   0.83   0.43   0.32 
 45      0.40   0.46   0.86   0.64   0.33   0.25 
 50      0.32   0.37   0.68   0.51   0.26   0.20 
 55      0.27   0.30   0.56   0.41   0.22   0.16 
Limits: 26.76  31.88  42.20  36.96  27.38  23.84  comb all 400
 Output for sample comb,all and mass 450
 30      1.28   1.89   3.53   2.63   1.36   1.01 
 35      1.03   1.35   2.52   1.88   0.97   0.72 
 40      0.83   1.00   1.87   1.40   0.72   0.54 
 45      0.67   0.77   1.44   1.07   0.56   0.42 
 50      0.55   0.61   1.14   0.85   0.44   0.33 
 55      0.46   0.50   0.93   0.69   0.36   0.27 
 60      0.39   0.41   0.77   0.57   0.30   0.22 
 65      0.33   0.35   0.65   0.48   0.25   0.19 
 70      0.29   0.29   0.55   0.41   0.21   0.16 
Limits: 35.75  40.00  53.33  46.59  34.62  30.17  comb all 450
 Output for sample comb,all and mass 500
 30      1.70   2.88   5.41   4.01   2.08   1.55 
 35      1.48   2.15   4.02   2.99   1.55   1.15 
 40      1.25   1.62   3.03   2.26   1.17   0.87 
 45      1.05   1.26   2.35   1.75   0.91   0.67 
 50      0.88   1.00   1.86   1.39   0.72   0.54 
 55      0.75   0.81   1.51   1.12   0.58   0.43 
 60      0.64   0.67   1.25   0.93   0.48   0.36 
 65      0.55   0.56   1.05   0.78   0.40   0.30 
 70      0.48   0.48   0.89   0.66   0.34   0.26 
Limits: 46.47  50.00  66.56  58.16  43.27  37.68  comb all 500
 --
Limits:  4.06   8.95  12.64  10.84   7.40   6.02  comb all 90
Limits:  4.16   6.73   9.24   7.81   5.26   3.43  comb all 100
Limits:  3.11   7.08   9.74   8.41   5.46   3.42  comb all 110
Limits:  2.91   7.08  10.15   8.55   5.46   3.42  comb all 120
Limits:  2.66   7.25  10.62   8.86   5.63   3.69  comb all 130
Limits:  1.60   7.55  11.10   9.19   6.21   4.54  comb all 140
Limits:  1.08   8.00  11.50   9.62   6.47   4.63  comb all 150
Limits:  2.62   8.55  12.43  10.46   7.33   6.30  comb all 170
Limits:  4.19  10.45  14.76  12.57   8.61   7.39  comb all 200
Limits: 10.56  14.93  20.12  17.67  12.49  10.54  comb all 250
Limits: 15.16  19.79  26.59  23.00  17.14  14.76  comb all 300
Limits: 21.11  25.70  34.21  29.78  22.25  19.36  comb all 350
Limits: 26.76  31.88  42.20  36.96  27.38  23.84  comb all 400
Limits: 35.75  40.00  53.33  46.59  34.62  30.17  comb all 450
Limits: 46.47  50.00  66.56  58.16  43.27  37.68  comb all 500
*/
// Warning: results may be extrapolated

   // --> LepLimit
   TCutG *cutg = new TCutG("cutg_lep",38);
   cutg->SetVarX("");
   cutg->SetVarY("");
   cutg->SetTitle("H_LEP");
   cutg->SetFillColor(1);
   cutg->SetFillStyle(3004);
   cutg->SetLineWidth(2);
   cutg->SetMarkerStyle(20);
   cutg->SetMarkerSize(1.2);
   cutg->SetPoint(0,90.25843,49.58802);
   cutg->SetPoint(1,93.25843,49.58802);
   cutg->SetPoint(2,92.69663,43.22097);
   cutg->SetPoint(3,92.97753,37.15356);
   cutg->SetPoint(4,92.97753,31.68539);
   cutg->SetPoint(5,93.53933,24.19476);
   cutg->SetPoint(6,93.53933,19.40075);
   cutg->SetPoint(7,93.25843,15.50562);
   cutg->SetPoint(8,93.82023,12.73408);
   cutg->SetPoint(9,93.53933,10.93633);
   cutg->SetPoint(10,94.66293,9.138577);
   cutg->SetPoint(11,95.50562,7.940076);
   cutg->SetPoint(12,96.91012,6.891387);
   cutg->SetPoint(13,97.75281,6.441948);
   cutg->SetPoint(14,99.43821,5.692885);
   cutg->SetPoint(15,102.2472,5.318352);
   cutg->SetPoint(16,103.9326,5.093633);
   cutg->SetPoint(17,105.618,5.018727);
   cutg->SetPoint(18,106.4607,5.468165);
   cutg->SetPoint(19,108.7079,6.217229);
   cutg->SetPoint(20,109.8315,6.591761);
   cutg->SetPoint(21,111.5169,6.891387);
   cutg->SetPoint(22,113.2022,7.116106);
   cutg->SetPoint(23,115.4494,7.116106);
   cutg->SetPoint(24,117.4157,6.891387);
   cutg->SetPoint(25,120.2247,6.367042);
   cutg->SetPoint(26,123.0337,5.767791);
   cutg->SetPoint(27,128.9326,4.868915);
   cutg->SetPoint(28,134.2697,4.269663);
   cutg->SetPoint(29,140.4494,3.745319);
   cutg->SetPoint(30,146.0674,3.445693);
   cutg->SetPoint(31,152.2472,3.295881);
   cutg->SetPoint(32,174.7191,2.771535);
   cutg->SetPoint(33,189.3259,2.621724);
   cutg->SetPoint(34,198.3146,2.471911);
   cutg->SetPoint(35,500,2.471911);
   cutg->SetPoint(36,500,0);
   cutg->SetPoint(37,0,0);
   //  cutg->Draw("f");
   TCutG  *cutg1 = new TCutG("cutg1_lep",38);
   cutg1->SetVarX("");
   cutg1->SetVarY("");
   cutg1->SetTitle("H_LEP");
   cutg1->SetFillColor(1);
   cutg1->SetFillStyle(3004);
   cutg1->SetLineWidth(2);
   cutg1->SetMarkerStyle(20);
   cutg1->SetMarkerSize(1.2);
   cutg1->SetPoint(0,90.25843,49.58802);
   cutg1->SetPoint(1,93.25843,49.58802);
   cutg1->SetPoint(2,92.69663,43.22097);
   cutg1->SetPoint(3,92.97753,37.15356);
   cutg1->SetPoint(4,92.97753,31.68539);
   cutg1->SetPoint(5,93.53933,24.19476);
   cutg1->SetPoint(6,93.53933,19.40075);
   cutg1->SetPoint(7,93.25843,15.50562);
   cutg1->SetPoint(8,93.82023,12.73408);
   cutg1->SetPoint(9,93.53933,10.93633);
   cutg1->SetPoint(10,94.66293,9.138577);
   cutg1->SetPoint(11,95.50562,7.940076);
   cutg1->SetPoint(12,96.91012,6.891387);
   cutg1->SetPoint(13,97.75281,6.441948);
   cutg1->SetPoint(14,99.43821,5.692885);
   cutg1->SetPoint(15,102.2472,5.318352);
   cutg1->SetPoint(16,103.9326,5.093633);
   cutg1->SetPoint(17,105.618,5.018727);
   cutg1->SetPoint(18,106.4607,5.468165);
   cutg1->SetPoint(19,108.7079,6.217229);
   cutg1->SetPoint(20,109.8315,6.591761);
   cutg1->SetPoint(21,111.5169,6.891387);
   cutg1->SetPoint(22,113.2022,7.116106);
   cutg1->SetPoint(23,115.4494,7.116106);
   cutg1->SetPoint(24,117.4157,6.891387);
   cutg1->SetPoint(25,120.2247,6.367042);
   cutg1->SetPoint(26,123.0337,5.767791);
   cutg1->SetPoint(27,128.9326,4.868915);
   cutg1->SetPoint(28,134.2697,4.269663);
   cutg1->SetPoint(29,140.4494,3.745319);
   cutg1->SetPoint(30,146.0674,3.445693);
   cutg1->SetPoint(31,152.2472,3.295881);
   cutg1->SetPoint(32,174.7191,2.771535);
   cutg1->SetPoint(33,189.3259,2.621724);
   cutg1->SetPoint(34,198.3146,2.471911);
   cutg1->SetPoint(35,500,2.471911);
   cutg1->SetPoint(36,500,0);
   cutg1->SetPoint(37,0,0);
   //cutg1->Draw("l");


   // ATLAS 1fb limit
 TGraphAsymmErrors *g1fbc  = new TGraphAsymmErrors(); // expected ATLAS 1fb comb
 g1fbc->SetPoint(0,  90 ,  19.6858);
 g1fbc->SetPoint(1,  100,  21.9139);
 g1fbc->SetPoint(2,  110,  18.72  );
 g1fbc->SetPoint(3,  120,  15.0636);
 g1fbc->SetPoint(4,  130,  13.9442);
 g1fbc->SetPoint(5,  140,  13.301 );
 g1fbc->SetPoint(6,  150,  12.9621);
 g1fbc->SetPoint(7,  170,  13.4555);
 g1fbc->SetPoint(8,  200,  16.2775);
 g1fbc->SetPoint(9,  250,  22.811 );
 g1fbc->SetPoint(10, 300,  28.8931);
 g1fbc->SetPoint(11, 350,  36.3968);
 g1fbc->SetPoint(12, 400,  46.695 );
 g1fbc->SetPoint(13, 450,  60.8669);
 g1fbc->SetPoint(14, 500,  70.0163);
 /*
mass : 90 observed :  28.1617 expected : 19.6858  23.259 17.2383 26.5841 14.7437
mass : 100 observed : 18.0019 expected : 21.9139  25.6572 18.5798 29.6831 15.6894
mass : 110 observed : 16.5195 expected : 18.72    22.3094 15.4007 25.7801 13.3745
mass : 120 observed : 13.7887 expected : 15.0636  18.4764 13.2053 21.3445 10.9513
mass : 130 observed : 14.0607 expected : 13.9442  16.5681 11.5639 19.2262 9.50076
mass : 140 observed : 14.1903 expected : 13.301   15.7945 10.5023 18.6408 9.2871
mass : 150 observed : 16.4692 expected : 12.9621  14.9061 10.3817 17.8112 9.0714
mass : 170 observed : 15.8182 expected : 13.4555  15.3859 11.1091 18.2567 9.61597
mass : 200 observed : 16.4577 expected : 16.2775  19.1324 14.0342 22.1213 12.2888
mass : 250 observed : 19.9607 expected : 22.811   26.5438 19.4014 30.4351 17.1241
mass : 300 observed : 23.9082 expected : 28.8931  33.6513 24.754 38.6039 22.0053
mass : 350 observed : 30.6219 expected : 36.3968  42.2568 31.5382 48.3297 27.9206
mass : 400 observed : 37.8913 expected : 46.695   54.2975 40.2739 61.5315 35.2814
mass : 450 observed : 48.6811 expected : 60.8669  67.2031 52.8364 71.3267 46.3753
mass : 500 observed : 62.8118 expected : 70.0163  73.5215 64.8433 75.8887 58.6795 
 */

//  TFile *fcms = new TFile("../cms.root","read");
//  TGraph *cms_exp = (TGraph*) fcms->Get("cms/Expected"); 
//  TGraph *cms_obs = (TGraph*) fcms->Get("cms/Observed"); 
//  cms_exp->SetMarkerSize(0.5);
//  cms_exp->SetLineWidth(3);
//  cms_exp->SetLineStyle(4);
//  cms_exp->SetLineColor(4);
//  cms_obs->SetMarkerSize(0.5);
//  cms_obs->SetLineWidth(2);


   TCanvas *c = new TCanvas("c","c",600,600);
   g->SetMarkerStyle(20);
   g0->GetYaxis()->SetTitle("tan#beta");
   g0->GetXaxis()->SetTitle("m_{A} [GeV/c^{2}]");
   g0->SetLineStyle(2);
   g1->SetLineStyle(2);
   g2->SetLineStyle(2);
   g0->SetLineWidth(2);
   g1->SetLineWidth(2);
   g2->SetLineWidth(2);
   g1->SetFillColor(kGreen);
   g2->SetFillColor(kYellow);
   g0->GetYaxis()->SetRangeUser(0,60);

   TH1F *h_axes = new TH1F("","", 100, 90, 500);
   h_axes->Fill(-10, 1000);
   h_axes->GetYaxis()->SetTitle("tan#beta");
   h_axes->GetXaxis()->SetTitle("m_{A} [GeV/c^{2}]");

   h_axes->GetYaxis()->SetRangeUser(0,60);
   h_axes->SetLineColor(0);
   h_axes->Draw("HIST");
   

   g0->Draw("L,same");
   g2->Draw("E3,same");
   g1->Draw("E3,same");
   g0->Draw("L,same");
   cutg->Draw("f,same");
   cutg1->Draw("l,same");
   // sg0->Draw("L,same");
   //csg1->Draw("L,same"); // CMS result

//    g0V2->SetLineColor(2);
//    g0V2->SetLineWidth(2);
//    g0V2->Draw("L,same");

//    g0V1->SetLineColor(4);
//    g0V1->SetLineWidth(2);
//    g0V1->Draw("L,same");

//    g1fbc->SetLineColor(9);
//    g1fbc->SetLineWidth(3);
//    g1fbc->SetLineStyle(2);
//    g1fbc->Draw("L,same");

//    cms_obs->SetLineWidth(3);
//    cms_obs->Draw("L,same");
//    cms_exp->Draw("L,same");
   g->Draw("PL,same");
   TLegend *leg = new TLegend(0.15+0.47, 0.55-0.33, 0.45+0.47, 0.77-0.33);
    leg->SetFillColor(kWhite);
    leg->SetFillStyle(0);
    leg->SetLineColor(0);
    g2->SetLineColor(0);
    g1->SetLineColor(0);
    g2->SetLineStyle(0);
    g1->SetLineStyle(0);
    leg->AddEntry(g, "Observed CLs", "LP");
    leg->AddEntry(g0, "Expected CLs", "L");
    leg->AddEntry(g1,"1 #sigma", "F");
    leg->AddEntry(g2,"2 #sigma", "F");
    leg->AddEntry(cutg,"LEP Exclusion", "F");
//     leg->AddEntry(g0V1,"Exp, vis mass", "L");
//     leg->AddEntry(g0V2,"Exp, Stats Only", "L");
//     leg->AddEntry(g1fbc,"ATLAS comb 1fb^{-1}", "L");
//     leg->AddEntry(cms_exp,"CMS Exp.", "L");
//     leg->AddEntry(cms_obs,"CMS Obs.", "L");

    // leg->AddEntry(sg0,"ATLAS Exp. 1fb^{-1}", "L");
    // leg->AddEntry(csg1,"CMS Exp. 4.6fb^{-1} (lh+ll) Dec11", "L");
    //leg->AddEntry(csg1,"CMS Exp. (lh+ll) Dec11", "L");

    leg->Draw("same");
    TLatex *l = new TLatex;
    l->SetNDC();
    l->SetTextFont(72);
    l->SetTextColor(1);
    l->SetTextSize(0.04);
    //    l->DrawLatex(0.15,0.87,"#splitline{ATLAS Internal, Preliminary, 2011}{4.66 fb^{-1}, #sqrt{s}=7 TeV}");
    l->DrawLatex(0.15,0.87,"ATLAS Internal, 2011");
    TLatex *l1 = new TLatex;
    l1->SetNDC();
    l1->SetTextFont(72);
    l1->SetTextColor(1);
    l1->SetTextSize(0.04);
    l1->DrawLatex(0.15,0.81,"H#rightarrow #tau#tau / #mu#mu combination, m_{h}^{max} scenario");
    TLatex *l2 = new TLatex;
    l2->SetNDC();
    l2->SetTextFont(72);
    l2->SetTextColor(1);
    l2->SetTextSize(0.04);
    l1->DrawLatex(0.15,0.73,"#int L dt = 4.7-4.8 fb^{-1}, #sqrt{s}=7 TeV");

    gPad->RedrawAxis();
    c->Print("limit_comb.eps");
    c->Print("limit_comb.png");

    // make a root file
    TString folder="All_combined";
    TString filename=folder+".root";
    TFile *file=new TFile(filename,"RECREATE");
    file->mkdir(folder);
    file->cd(folder);
    TGraph *obs=(TGraph*)g->Clone();
    obs->SetName("Observed");
    gDirectory->Append(obs);
    TGraph *exp=(TGraph*)g0->Clone();
    exp->SetName("Expected");
    gDirectory->Append(exp);
    g1->SetName("Expected1sigma");
    gDirectory->Append(g1);
    g2->SetName("Expected2sigma");
    gDirectory->Append(g2);
    file->Write();
    file->Close();

}
