#if !defined(UTIL_H)
#define UTIL_H

#include <gsl/gsl_matrix.h>

struct stability_params {
  double lambda[8];
  double l;
  double u;
  double m;
  double v;
};

struct integration_params {
  double M;
  double m1;
  double m2;
  double gamma;
};

double stability_fcn(double x, void *params);

bool stability_minimum(stability_params &p);

void print_gsl_matrix(gsl_matrix *mat,int m,int n);

double fint(double x, void* par);

double gint(double x, void* par);

double Lint_s(double x, void *param);

double Lint_p(double x, void *param);

double Lint_c(double x, void *param);

double hvv_fcn(double y, void *params);

double hvh_fcn(double x, void *params);



#endif
