#include "Util.h"
#include <gsl/gsl_min.h>
#include <cmath>
#include <gsl/gsl_errno.h>


double stability_fcn(double x, void *params) {
  stability_params p=*(stability_params*)params;
  return (1./2.)*p.lambda[1]*pow(cos(x),4.)+(1./2.)*p.lambda[2]*pow(sin(x),4.)+(p.lambda[3]+p.lambda[4]+p.lambda[5])*cos(x)*cos(x)*sin(x)*sin(x)+(2*(p.lambda[6]*cos(x)*cos(x)+p.lambda[7]*sin(x)*sin(x)))*sin(x)*cos(x);
}

bool stability_minimum(stability_params &p) {
  int status;
  int iter = 0, max_iter = 100;
  const gsl_min_fminimizer_type *T;
  gsl_min_fminimizer *s;
  double m = p.m;
  double a = p.l, b = p.u;
  gsl_function F;
  double abs_err=0.00001;

  F.function = &stability_fcn;
  F.params = &p;
  
  T = gsl_min_fminimizer_brent;
  s = gsl_min_fminimizer_alloc (T);
  gsl_error_handler_t *old_handler = gsl_set_error_handler_off();

  status=gsl_min_fminimizer_set (s, &F, m, a, b);

  do
    {
      iter++;
      status = gsl_min_fminimizer_iterate (s);
      m = gsl_min_fminimizer_x_minimum (s);
      a = gsl_min_fminimizer_x_lower (s);
      b = gsl_min_fminimizer_x_upper (s);
      
      status = gsl_min_test_interval (a, b, abs_err, 0.0);
     
    }
  while (status == GSL_CONTINUE && iter < max_iter);
  
  p.m=m;
  p.v=gsl_min_fminimizer_f_minimum(s);
  gsl_min_fminimizer_free (s);
  gsl_set_error_handler(old_handler);
  if (((m-p.l)<=abs_err)||((p.u-m)<=abs_err)) return false;
  return (status == GSL_SUCCESS);
}


void print_gsl_matrix(gsl_matrix *mat,int m,int n) {
  printf("\n");
  for (int i=0;i<m;i++) {
    for (int j=0;j<n;j++) {
      double x = gsl_matrix_get(mat,i,j);
      printf("%16.8g",x);
    }
    printf("\n");
  }

}


double Lint_s(double x, void *param) {

  double z = *(double*)param;
  double f = x*x*(2.-x)/(x*x+(1.-x)*z);
  return f;
}

double Lint_p(double x, void *param) {

  double z = *(double*)param;
  double f = -x*x*x/(x*x+(1.-x)*z);
  return f;
}

double Lint_c(double x, void *param) {

  double z = *(double*)param;
  double f = -x*(1.-x)/(x+z-1);
  return f;
}


double fint(double x, void *param) {

  double z = *(double*)param;
  double f = (1.-2.*x*(1.-x))/(x*(1.-x)-z)*log(x*(1.-x)/z);
  return f;
}

double gint(double x, void *param) {

  double z = *(double*)param;
  double f = 1./(x*(1.-x)-z)*log(x*(1.-x)/z);
  return f;
}

double hvv_fcn(double y, void *params) {

  integration_params ip = *((integration_params*)params);
  double mH = ip.M;
  double mV = ip.m1;
  double gV = ip.gamma;

  double k = pow(mV/mH,2);
  double rgV = pow(gV/mH,2);

  double cg0 =  k*rgV;
  double cg2 = k;
  double cg4 = y;

  double A[3];
  //   A[0] = cg1/sqrt(cg);
  //   A[1] = cg + pow(cg1,2);
  //   A[2] = 1./sqrt(cg);
  //   
  A[0] = k/sqrt(cg0);
  A[1] = cg0+pow(k,2);
  A[2] = 1./sqrt(cg0);

  double cg = -(-log(A[1]) * sqrt(cg0) + log(A[1]) * cg4 * sqrt(cg0) + 0.2e1 * log(A[1]) * cg2 * sqrt(cg0) - 0.2e1 * atan(A[0]) * cg4 + 0.2e1 * atan(A[0]) * cg2 - 0.4e1 * atan(A[0]) * pow(cg2, 0.2e1) + 0.2e1 * atan(A[0]) * pow(cg4, 0.2e1) + log(0.2e1 * cg2 * pow(cg4, 0.2e1) + pow(cg4, 0.4e1) + cg0 - 0.2e1 * cg2 * cg4 + pow(cg2, 0.2e1) + pow(cg4, 0.2e1) + cg0 * pow(cg4, 0.2e1) - 0.2e1 * cg0 * cg4 - 0.2e1 * pow(cg4, 0.3e1)) * sqrt(cg0) - 0.2e1 * log(0.1e1 - cg4) * sqrt(cg0) - cg4 * log(0.2e1 * cg2 * pow(cg4, 0.2e1) + pow(cg4, 0.4e1) + cg0 - 0.2e1 * cg2 * cg4 + pow(cg2, 0.2e1) + pow(cg4, 0.2e1) + cg0 * pow(cg4, 0.2e1) - 0.2e1 * cg0 * cg4 - 0.2e1 * pow(cg4, 0.3e1)) * sqrt(cg0) + 0.2e1 * cg4 * log(0.1e1 - cg4) * sqrt(cg0) - 0.2e1 * cg2 * log(0.2e1 * cg2 * pow(cg4, 0.2e1) + pow(cg4, 0.4e1) + cg0 - 0.2e1 * cg2 * cg4 + pow(cg2, 0.2e1) + pow(cg4, 0.2e1) + cg0 * pow(cg4, 0.2e1) - 0.2e1 * cg0 * cg4 - 0.2e1 * pow(cg4, 0.3e1)) * sqrt(cg0) + 0.4e1 * cg2 * log(0.1e1 - cg4) * sqrt(cg0) - 0.2e1 * atan((cg2 + pow(cg4, 0.2e1) - cg4) / (-0.1e1 + cg4) * A[2]) * cg4 + 0.2e1 * atan((cg2 + pow(cg4, 0.2e1) - cg4) / (-0.1e1 + cg4) * A[2]) * cg2 - 0.4e1 * atan((cg2 + pow(cg4, 0.2e1) - cg4) / (-0.1e1 + cg4) * A[2]) * pow(cg2, 0.2e1) + 0.2e1 * atan((cg2 + pow(cg4, 0.2e1) - cg4) / (-0.1e1 + cg4) * A[2]) * pow(cg4, 0.2e1)) * A[2] / 0.2e1;

  return cg;

}



double hvh_fcn(double x, void *params) {

  integration_params ip = *((integration_params*)params);

  double M = ip.M;
  double m1 = ip.m1;
  double m2 = ip.m2;
  double gV = ip.gamma;

  double k1 = pow(m1/M,2);
  double k2 = pow(m2/M,2);
  double g  = k2*pow(gV/M,2);

  double A[3];
  A[0] = k2/sqrt(g);
  A[1] = g+pow(k2,2); 
  A[2] = 1./sqrt(g);

  double cg0 = k2;
  double cg2 = g;
  double cg4 = k1;
  double cg6 = x;
  

  // Maple code for differential width
  double cg = (-log(A[1]) * cg6 * sqrt(cg2) + log(A[1]) * sqrt(cg2) + 0.2e1 * atan(A[0]) * cg6 - 0.2e1 * atan(A[0]) * pow(cg6, 0.2e1) - 0.2e1 * atan(A[0]) * cg6 * cg4 + 0.2e1 * atan(A[0]) * cg6 * cg0 - 0.2e1 * atan(A[0]) * cg0 + cg6 * log(cg2 - 0.2e1 * pow(cg6, 0.3e1) + cg2 * pow(cg6, 0.2e1) + pow(cg0, 0.2e1) + pow(cg6, 0.2e1) - 0.2e1 * cg6 * cg0 + pow(cg6, 0.4e1) - 0.2e1 * pow(cg0, 0.2e1) * cg6 + 0.4e1 * cg0 * pow(cg6, 0.2e1) + 0.2e1 * cg0 * cg6 * cg4 - 0.2e1 * cg4 * cg0 * pow(cg6, 0.2e1) + pow(cg0, 0.2e1) * pow(cg6, 0.2e1) + 0.2e1 * pow(cg6, 0.3e1) * cg4 - 0.2e1 * pow(cg6, 0.3e1) * cg0 + pow(cg4, 0.2e1) * pow(cg6, 0.2e1) - 0.2e1 * cg2 * cg6 - 0.2e1 * cg4 * pow(cg6, 0.2e1)) * sqrt(cg2) - 0.2e1 * cg6 * log(0.1e1 - cg6) * sqrt(cg2) - log(cg2 - 0.2e1 * pow(cg6, 0.3e1) + cg2 * pow(cg6, 0.2e1) + pow(cg0, 0.2e1) + pow(cg6, 0.2e1) - 0.2e1 * cg6 * cg0 + pow(cg6, 0.4e1) - 0.2e1 * pow(cg0, 0.2e1) * cg6 + 0.4e1 * cg0 * pow(cg6, 0.2e1) + 0.2e1 * cg0 * cg6 * cg4 - 0.2e1 * cg4 * cg0 * pow(cg6, 0.2e1) + pow(cg0, 0.2e1) * pow(cg6, 0.2e1) + 0.2e1 * pow(cg6, 0.3e1) * cg4 - 0.2e1 * pow(cg6, 0.3e1) * cg0 + pow(cg4, 0.2e1) * pow(cg6, 0.2e1) - 0.2e1 * cg2 * cg6 - 0.2e1 * cg4 * pow(cg6, 0.2e1)) * sqrt(cg2) + 0.2e1 * log(0.1e1 - cg6) * sqrt(cg2) + 0.2e1 * atan((cg4 * cg6 - cg6 * cg0 + pow(cg6, 0.2e1) - cg6 + cg0) / (-0.1e1 + cg6) * A[2]) * cg6 - 0.2e1 * atan((cg4 * cg6 - cg6 * cg0 + pow(cg6, 0.2e1) - cg6 + cg0) / (-0.1e1 + cg6) * A[2]) * pow(cg6, 0.2e1) - 0.2e1 * atan((cg4 * cg6 - cg6 * cg0 + pow(cg6, 0.2e1) - cg6 + cg0) / (-0.1e1 + cg6) * A[2]) * cg6 * cg4 + 0.2e1 * atan((cg4 * cg6 - cg6 * cg0 + pow(cg6, 0.2e1) - cg6 + cg0) / (-0.1e1 + cg6) * A[2]) * cg6 * cg0 - 0.2e1 * atan((cg4 * cg6 - cg6 * cg0 + pow(cg6, 0.2e1) - cg6 + cg0) / (-0.1e1 + cg6) * A[2]) * cg0) * A[2] / 0.2e1;


  return cg;

}

