/*******************************************************************************
 2HDMC - two-Higgs-doublet model calculator
 Demo program
 
 http://www.isv.uu.se/thep/MC/2hdmc
*******************************************************************************/
#include "THDM.h"
#include "SM.h"
#include "Constraints.h"
#include "DecayTable.h"
#include <iostream>

using namespace std;

int main(int argc, char* argv[]) {

  // Reference SM Higgs mass for EW precision observables
  double mh_ref = 117.;

  // Create SM and set top mass to 175 GeV
  SM sm;
  sm.set_qmass_pole(6, 175.);		

  // Create 2HDM and set SM parameters
  THDM model;
  model.set_SM(sm);
	  
  // Set parameters of the 2HDM in the 'physical' basis
  double mh       = 125.;
  double mH       = atof(argv[1]);
  double mA       = mH;
  double mC       = mH;
  double sba      = atof(argv[2]);
  double lambda_6 = 0.;
  double lambda_7 = 0.;
  double tb       = atof(argv[3]);
  double m12_2    = mH*mH*tb/(1+tb*tb); 
  int yukawas     = 2;
  bool pset = model.set_param_phys(mh,mH,mA,mC,sba,lambda_6,lambda_7,m12_2,tb);

  int  i_index = atoi(argv[4]);;
  
  if (!pset) {
    cerr << "The specified parameters are not valid\n";
    return -1;
  }

  // Set Yukawa couplings to type II
  model.set_yukawas_type(yukawas);
  
  // Print the parameters in different parametrizations
  // model.print_param_phys();
  // model.print_param_gen();
  // model.print_param_higgs();

  // Prepare to calculate observables
  Constraints constr(model);

  double S,T,U,V,W,X;   

  constr.oblique_param(mh_ref,S,T,U,V,W,X);
  
  // printf("\nConstraints:\n");
  // printf("  Potential stability: %s\n", 
  // 	 (constr.check_stability() ? "OK" : "Not OK"));
  // printf(" Tree-level unitarity: %s\n", 
  // 	 (constr.check_unitarity() ? "OK" : "Not OK"));
  // printf("       Perturbativity: %s\n", 
  // 	 (constr.check_perturbativity() ? "OK" : "Not OK"));
  // printf("     Mass constraints: %s\n", 
  // 	 (constr.check_masses() ? "OK" : "Not OK"));
  //return 0;

  int status = 0;
  if (! constr.check_stability() ) status += 1;
  if (! constr.check_unitarity() ) status += 2;
  if (! constr.check_perturbativity() ) status += 4;
  //  printf("\n");
  //printf(" Oblique S: %12.5e\n", S);  
  //printf(" Oblique T: %12.5e\n", T);
  //printf(" Oblique U: %12.5e\n", U);  
  //printf(" Oblique V: %12.5e\n", V);
  //printf(" Oblique W: %12.5e\n", W);  
  //printf(" Oblique X: %12.5e\n", X);
  //printf(" Delta_rho: %12.5e\n", constr.delta_rho(mh_ref));
  //printf("\n");
  //printf(" Delta_amu: %12.5e\n\n", constr.delta_amu());

  // Prepare to calculate decay widths
  DecayTable table(model);

  // Print total widths of Higgs bosons
  //table.print_width(1);
  //table.print_width(2);
  //table.print_width(3);
  //table.print_width(4);	

  // Write output to LesHouches file
//   model.write_LesHouches("Demo_out.lha", 1, 0);
//   // extra: print BR: H->hh
//   cout << "Params: mH=" << mH << ", sba= " << sba << " type: " << yukawas << " tanb=" << tb << " m122=" << m12_2 << endl; 
//   cout << "BR H->hh: " << table.get_gamma_hhh(2,1,1)/table.get_gammatot_h(2)
//        << endl;  
//   cout << "BR H->ZZ: " << table.get_gamma_hvv(2,2)/table.get_gammatot_h(2)  << endl;
//   cout << "BR h->ZZ: " << table.get_gamma_hvv(1,2)/table.get_gammatot_h(1)  << endl;
  
 printf("status[%i] = %i ; tanb[%i]= %f ; sba[%i]= %f ; mH[%i] = %f ;  br_H_ZZ[%i] = %f ; width_H[%i] = %f ; br_H_hh[%i] = %f; // check \n", 
	i_index, status, i_index,  tb, i_index,  sba, i_index, mH,   i_index, table.get_gamma_hvv(2,2)/table.get_gammatot_h(2),
	i_index, table.get_gammatot_h(2), i_index, table.get_gamma_hhh(2,1,1)/table.get_gammatot_h(2));

}

